/*
 * Decompiled with CFR 0.152.
 */
package name.modid;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import name.modid.CombatBarManager;
import name.modid.CombatCooldownManager;
import name.modid.Config;
import name.modid.ScoreboardManager;
import name.modid.access.ServerPlayerEntityAccess;
import name.modid.events.PlayerAttackCallback;
import name.modid.events.PlayerDamageCallback;
import name.modid.events.PlayerDeathCallback;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8111;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombatTag
implements ModInitializer {
    public static final String MOD_ID = "combat-tag";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"combat-tag");
    public static final Set<class_1792> weapons = Set.of(class_1802.field_22022, class_1802.field_8802, class_1802.field_8371, class_1802.field_8845, class_1802.field_8528, class_1802.field_8091, class_1802.field_22025, class_1802.field_8556, class_1802.field_8475, class_1802.field_8825, class_1802.field_8062, class_1802.field_8406, class_1802.field_8547, class_1802.field_49814, class_1802.field_8102, class_1802.field_8399);

    public void onInitialize() {
        LOGGER.info("[{}] loading config...", (Object)MOD_ID);
        try {
            Config.load();
            LOGGER.info("[{}] config loaded", (Object)MOD_ID);
        }
        catch (IOException e1) {
            LOGGER.warn("[{}] could not load config", (Object)MOD_ID);
            try {
                LOGGER.info("[{}] generating new config file...", (Object)MOD_ID);
                Config.write();
                LOGGER.info("[{}] config generated successfully", (Object)MOD_ID);
            }
            catch (IOException e2) {
                LOGGER.error("[{}] could not write new config file {}", (Object)MOD_ID, (Object)e2.getMessage());
            }
        }
        PlayerDeathCallback.EVENT.register(CombatTag::onPlayerDeath);
        PlayerDamageCallback.EVENT.register(CombatTag::onPlayerDamage);
        PlayerAttackCallback.EVENT.register(CombatTag::onPlayerAttack);
        if (Config.ENABLE_COMBAT_COLOUR) {
            ServerTickEvents.END_SERVER_TICK.register(ScoreboardManager::tickScoreboard);
        }
        ServerTickEvents.END_SERVER_TICK.register(CombatBarManager::tickCombatBars);
        LOGGER.info("[{}] listening on event channels", (Object)MOD_ID);
    }

    private static void combatTag(class_3222 player) {
        if (!player.method_36608()) {
            LOGGER.warn("[{}] combat tag called on player {} who is not part of the game", (Object)MOD_ID, (Object)player.method_5477().getString());
            return;
        }
        if (player.method_68878()) {
            LOGGER.warn("[{}] combat tag called on player {} who is in creative mode", (Object)MOD_ID, (Object)player.method_5477().getString());
            return;
        }
        ServerPlayerEntityAccess combatAccessor = (ServerPlayerEntityAccess)player;
        if (!combatAccessor.combat_tag$inCombat()) {
            LOGGER.info("[{}] combat tagged {}", (Object)MOD_ID, (Object)player.method_5477().getString());
        }
        combatAccessor.combat_tag$setCombat(true);
        if (Config.ENABLE_INSTANT_TP_PUNISH) {
            CombatCooldownManager.tagCooldowns(player);
        }
        if (Config.ENABLE_ELYTRA_PUNISH) {
            player.method_66281();
        }
    }

    public static void removeCombatTag(class_3222 player) {
        ServerPlayerEntityAccess combatAccessor = (ServerPlayerEntityAccess)player;
        if (combatAccessor.combat_tag$inCombat()) {
            LOGGER.info("[{}] removed combat tag from {}", (Object)MOD_ID, (Object)player.method_5477().getString());
        }
        combatAccessor.combat_tag$setCombat(false);
    }

    private static void onPlayerDeath(class_3222 player, class_1282 source) {
        CombatTag.removeCombatTag(player);
    }

    private static void onPlayerDamage(class_3222 player, class_1282 source) {
        class_3222 attacker = null;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 serverPlayerEntity;
            attacker = serverPlayerEntity = (class_3222)class_12972;
        } else {
            class_1676 projectile;
            class_12972 = source.method_5529();
            if (class_12972 instanceof class_1676 && (class_12972 = (projectile = (class_1676)class_12972).method_24921()) instanceof class_3222) {
                class_3222 serverPlayerEntity;
                attacker = serverPlayerEntity = (class_3222)class_12972;
            }
        }
        if (attacker != null && !attacker.equals((Object)player)) {
            block13: {
                if (Config.ONLY_TAG_WEAPONS) {
                    try {
                        Optional damageTypeKey;
                        LOGGER.info("[{}] player damaged by weapon {}", (Object)MOD_ID, (Object)Objects.requireNonNull(source.method_60948()).method_7909().toString());
                        LOGGER.info("[{}] player damaged by damage type {}", (Object)MOD_ID, (Object)source.method_48792().toString());
                        if (!weapons.contains(Objects.requireNonNull(source.method_60948()).method_7909()) && (damageTypeKey = source.method_48793().method_40230()).isPresent() && !((class_5321)damageTypeKey.get()).equals(class_8111.field_42332)) {
                            return;
                        }
                    }
                    catch (NullPointerException ignored) {
                        Optional damageTypeKey = source.method_48793().method_40230();
                        if (!damageTypeKey.isPresent() || ((class_5321)damageTypeKey.get()).equals(class_8111.field_42332)) break block13;
                        return;
                    }
                }
            }
            CombatTag.combatTag(player);
            if (Config.ENABLE_TAG_ON_ATTACK) {
                CombatTag.combatTag(attacker);
            }
            return;
        }
        if (!Config.ENABLE_PVE_TAG_ON_DAMAGE) {
            return;
        }
        if (source.method_5529() instanceof class_1309) {
            CombatTag.combatTag(player);
        } else {
            class_1676 projectile;
            class_1297 class_12973 = source.method_5529();
            if (class_12973 instanceof class_1676 && (projectile = (class_1676)class_12973).method_24921() instanceof class_1309) {
                CombatTag.combatTag(player);
            }
        }
    }

    private static void onPlayerAttack(class_3222 player, class_1297 target) {
        if (Config.ENABLE_PVE_TAG_ON_ATTACK && target instanceof class_1309 && !player.equals((Object)target)) {
            CombatTag.combatTag(player);
        }
    }

    public static void logoutPunish(class_3222 player) {
        if (Config.ENABLE_HEALTH_PUNISH) {
            player.method_6033(Config.HEALTH_REMAINING_PUNISH);
        }
        if (Config.ENABLE_ABSORPTION_PUNISH) {
            player.method_6073(Config.ABSORPTION_REMAINING_PUNISH);
        }
        if (Config.ENABLE_POISON_PUNISH) {
            class_1293 poison = new class_1293(class_1294.field_5899, Config.POISON_DURATION, Config.POISON_AMPLIFIER);
            player.method_6092(poison);
        }
    }
}

