/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.orbofdominance.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.orbofdominance.client.model.ModelMagenta_Fireball;
import net.mcreator.orbofdominance.entity.MagentaFireballEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class MagentaFireballRenderer
extends EntityRenderer<MagentaFireballEntity, LivingEntityRenderState> {
    private static final ResourceLocation texture = ResourceLocation.parse((String)"orb_of_dominance:textures/entities/t_magentafireball.png");
    private final ModelMagenta_Fireball model;

    public MagentaFireballRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelMagenta_Fireball(context.bakeLayer(ModelMagenta_Fireball.LAYER_LOCATION));
    }

    public void render(LivingEntityRenderState state, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer vb = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(state.yRot - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f + state.xRot));
        this.model.setupAnim((EntityRenderState)state);
        this.model.renderToBuffer(poseStack, vb, packedLightIn, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferIn, packedLightIn);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(MagentaFireballEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.xRot = entity.getXRot(partialTicks);
        state.yRot = entity.getYRot(partialTicks);
    }
}

