/*
 * Decompiled with CFR 0.152.
 */
package io.github.simplexdev.quickcoordscopy.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class QuickCoordsCopyConfig {
    private static final String FORMATTING_KEY = "formatting";
    public static final String DEFAULT_COPY_FORMAT = "$x $y $z";
    public static String copyFormat;
    private static final String CONFIRMATION = "confirmation";
    public static final boolean DEFAULT_CONFIRMATION = true;
    public static boolean confirmation;
    private static final String CONFIRMATION_TYPE = "confirmationType";
    public static final boolean DEFAULT_CONFIRMATION_TYPE = false;
    public static boolean confirmationType;

    public static void save() {
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("quickcoordscopy.properties").toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            Properties properties = new Properties();
            properties.setProperty(FORMATTING_KEY, copyFormat);
            properties.setProperty(CONFIRMATION, String.valueOf(confirmation));
            properties.setProperty(CONFIRMATION_TYPE, String.valueOf(confirmationType));
            properties.store(writer, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void load() {
        Properties properties;
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("quickcoordscopy.properties").toFile();
        if (!configFile.exists()) {
            try (FileWriter writer = new FileWriter(configFile);){
                properties = new Properties();
                properties.setProperty(FORMATTING_KEY, DEFAULT_COPY_FORMAT);
                properties.setProperty(CONFIRMATION, String.valueOf(true));
                properties.setProperty(CONFIRMATION_TYPE, String.valueOf(false));
                properties.store(writer, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileReader reader = new FileReader(configFile);){
            properties = new Properties();
            properties.load(reader);
            copyFormat = properties.getProperty(FORMATTING_KEY, DEFAULT_COPY_FORMAT);
            confirmation = Boolean.parseBoolean(properties.getProperty(CONFIRMATION, String.valueOf(true)));
            confirmationType = Boolean.parseBoolean(properties.getProperty(CONFIRMATION_TYPE, String.valueOf(false)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalStateException e) {
            QuickCoordsCopyConfig.save();
        }
    }
}

