/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers;

import de.clickism.configured.Config;
import de.clickism.configured.ConfigOption;

public class ClickVillagersConfig {
    public static final Config CONFIG = Config.of((String)"config/ClickVillagers/config.yml").version(4).header("---------------------------------------------------------\nClickVillagers Config\nNOTE: RELOAD/RESTART SERVER FOR CHANGES TO TAKE EFFECT\n---------------------------------------------------------\n");
    public static final ConfigOption<Boolean> CHECK_UPDATES = CONFIG.optionOf("check_updates", true).description("Whether to check for updates on server start.\nRecommended!\n").appendDefaultValue();
    public static final ConfigOption<Boolean> CLAIMED_DAMAGE = CONFIG.optionOf("claimed_damage", false).description("Whether claimed villagers can take damage.").appendDefaultValue();
    public static final ConfigOption<Boolean> CLAIMED_IMMUNE_KILL_COMMAND = CONFIG.optionOf("claimed_immune_kill_command", true).description("Whether claimed villagers are immune to the /kill command.\nWon't do anything if \"claimed-villagers-take-damage\" is enabled.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ENABLE_HOPPERS = CONFIG.optionOf("enable_hoppers", true).header("---------------------------------------------------------\nHopper Settings\n---------------------------------------------------------\n").description("Whether villager hoppers should be enabled.").appendDefaultValue();
    public static final ConfigOption<Boolean> IGNORE_BABY_VILLAGERS = CONFIG.optionOf("ignore_baby_villagers", true).description("Whether baby villagers should be ignored by villager hoppers.").appendDefaultValue();
    public static final ConfigOption<Boolean> IGNORE_CLAIMED_VILLAGERS = CONFIG.optionOf("ignore_claimed_villagers", true).description("Whether claimed villagers should be ignored by villager hoppers.").appendDefaultValue();
    public static final ConfigOption<Integer> PARTNER_LIMIT_PER_PLAYER = CONFIG.optionOf("partner_limit_per_player", (Number)10).header("---------------------------------------------------------\nPartner Settings\n---------------------------------------------------------\n").description("Maximum number of partners per player.").appendDefaultValue();
    public static final ConfigOption<Boolean> SHOW_TRADES = CONFIG.optionOf("show_trades", true).header("---------------------------------------------------------\nTrade Settings\n---------------------------------------------------------\n").description("Whether to show the trades of villagers when they are picked up.\nOnly relevant trades are shown.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> FORMAT_TRADES = CONFIG.optionOf("format_trades", true).description("Format relevant trades on picked up villagers.\nThis will hide trades that are most likely not useful,\nand highlight important trades\nwith custom formatting and emojis.\n").appendDefaultValue();
    public static final ConfigOption<Long> COOLDOWN = CONFIG.optionOf("cooldown", (Number)0L).header("---------------------------------------------------------\nOther\n---------------------------------------------------------\n").description("Cooldown for picking up and claiming villagers in seconds.\nThis is useful to prevent players from collecting villagers very quickly.\nClaimed villagers will not be affected by the cooldown.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ALLOW_ZOMBIE_VILLAGERS = CONFIG.optionOf("allow_zombie_villagers", true).description("Whether to allow zombie villagers to be picked up.\nIf this is disabled, zombie villagers will not be picked up by villager hoppers.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ENABLE_PICKUP = CONFIG.optionOf("enable_pickup", true).description("Whether players can pick up villagers.\nAlready picked up villagers will not be affected by this setting.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ENABLE_CLAIMS = CONFIG.optionOf("enable_claims", true).description("Whether players can claim villagers.\nAlready claimed villagers will not be affected by this setting.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ENABLE_ANCHORS = CONFIG.optionOf("enable_anchors", true).description("Whether players can anchor villagers.\n").appendDefaultValue();
}

