/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.callback;

import de.clickism.clickvillagers.ClickVillagersConfig;
import de.clickism.clickvillagers.anchor.AnchorHandler;
import de.clickism.clickvillagers.callback.CooldownManager;
import de.clickism.clickvillagers.gui.VillagerClaimGui;
import de.clickism.clickvillagers.gui.VillagerEditGui;
import de.clickism.clickvillagers.util.MessageType;
import de.clickism.clickvillagers.util.Utils;
import de.clickism.clickvillagers.util.VersionHelper;
import de.clickism.clickvillagers.villager.PartnerState;
import de.clickism.clickvillagers.villager.PickupHandler;
import de.clickism.clickvillagers.villager.VillagerHandler;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1641;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3851;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

public class UseVillagerEntityCallback
implements UseEntityCallback {
    private final CooldownManager cooldownManager;

    public UseVillagerEntityCallback(CooldownManager cooldownManager) {
        this.cooldownManager = cooldownManager;
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        if (!hand.equals((Object)class_1268.field_5808)) {
            return class_1269.field_5811;
        }
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        if (!(entity instanceof class_1309) || !(entity instanceof class_3851)) {
            return class_1269.field_5811;
        }
        if (!((Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.ALLOW_ZOMBIE_VILLAGERS)).booleanValue() && entity instanceof class_1641) {
            return class_1269.field_5811;
        }
        class_1309 villager = (class_1309)((class_3851)entity);
        VillagerHandler<class_1309> villagerHandler = new VillagerHandler<class_1309>(villager);
        if (hitResult != null) {
            return class_1269.field_21466;
        }
        if (!player.method_5715()) {
            return this.handleTrade(player, villagerHandler);
        }
        class_1661 inventory = player.method_31548();
        class_1799 itemStack = VersionHelper.getSelectedStack(inventory);
        class_1792 item = itemStack.method_7909();
        if (item.equals(class_1802.field_8868)) {
            this.handleAnchor(player, villagerHandler);
            return class_1269.field_21466;
        }
        if (itemStack.method_31573(class_3489.field_42615)) {
            this.handleClaim(player, villagerHandler);
            return class_1269.field_21466;
        }
        if (villagerHandler.isOwner(player.method_5667()) || villagerHandler.hasOwner() && player.method_64475(4)) {
            this.handleEdit(player, villagerHandler);
            return class_1269.field_21466;
        }
        if (!((Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.ENABLE_PICKUP)).booleanValue()) {
            return class_1269.field_5811;
        }
        this.handlePickup(player, villagerHandler);
        return class_1269.field_21466;
    }

    private void handleClaim(class_1657 player, VillagerHandler<?> villagerHandler) {
        UUID owner = villagerHandler.getOwner();
        class_3222 serverPlayer = (class_3222)player;
        if (owner == null) {
            if (!((Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.ENABLE_CLAIMS)).booleanValue()) {
                MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)"Claiming villagers is disabled."));
                return;
            }
            if (this.cooldownManager.hasCooldown(player)) {
                long seconds = this.cooldownManager.getRemainingCooldownSeconds(player);
                MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)("Please wait \u00a7l" + seconds + " seconds \u00a7cto claim this villager.")));
                return;
            }
            new VillagerClaimGui(serverPlayer, villagerHandler, this.cooldownManager).open();
            this.playOpenSound(player);
            return;
        }
        if (villagerHandler.isOwner(player.method_5667())) {
            this.handleEdit(player, villagerHandler);
            return;
        }
        MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)"This villager is already claimed."));
    }

    private class_1269 handleTrade(class_1657 player, VillagerHandler<?> villagerHandler) {
        if (villagerHandler.isTradingOpen()) {
            return class_1269.field_5811;
        }
        if (!villagerHandler.hasOwner()) {
            return class_1269.field_5811;
        }
        if (villagerHandler.isOwner(player.method_5667())) {
            return class_1269.field_5811;
        }
        PartnerState partnerState = PartnerState.getServerState(VersionHelper.getServer((class_1297)player));
        if (partnerState.isPartner(villagerHandler.getOwner(), player.method_5477().getString())) {
            return class_1269.field_5811;
        }
        MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)"This villager is closed for trading."));
        return class_1269.field_21466;
    }

    private void handleEdit(class_1657 player, VillagerHandler<?> villagerHandler) {
        new VillagerEditGui((class_3222)player, villagerHandler).open();
        this.playOpenSound(player);
    }

    private void handlePickup(class_1657 player, VillagerHandler<?> villagerHandler) {
        if (villagerHandler.hasOwner() && !villagerHandler.isOwner(player.method_5667())) {
            MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)"You can't pick up this villager."));
            return;
        }
        if (this.cooldownManager.hasCooldown(player)) {
            long seconds = this.cooldownManager.getRemainingCooldownSeconds(player);
            MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)("Please wait \u00a7l" + seconds + " seconds \u00a7cto pick up this villager.")));
            return;
        }
        PickupHandler.notifyPickup(player, villagerHandler.getEntity());
        class_1799 itemStack = PickupHandler.toItemStack(villagerHandler.getEntity());
        Utils.offerToHand(player, itemStack);
        this.cooldownManager.giveCooldown(player);
    }

    private void handleAnchor(class_1657 player, VillagerHandler<?> villagerHandler) {
        if (villagerHandler.hasOwner() && !villagerHandler.isOwner(player.method_5667())) {
            MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)"You can't anchor this villager."));
            return;
        }
        Object entity = villagerHandler.getEntity();
        class_3218 world = (class_3218)VersionHelper.getWorld(entity);
        if (AnchorHandler.isAnchored(entity)) {
            AnchorHandler.removeAnchorEffect(entity);
            MessageType.ANCHOR_REMOVE.sendActionbarSilently(player, (class_2561)class_2561.method_43470((String)"You removed this villager's anchor."));
            VersionHelper.playSound(player, class_3417.field_24063, class_3419.field_15250, 1.0f, 1.0f);
            world.method_65096((class_2394)class_2398.field_29643, entity.method_23317(), entity.method_23318(), entity.method_23321(), 10, 0.2, 0.0, 0.2, 2.0);
        } else {
            if (!((Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.ENABLE_ANCHORS)).booleanValue()) {
                MessageType.FAIL.send(player, (class_2561)class_2561.method_43470((String)"Anchoring villagers is disabled."));
                return;
            }
            AnchorHandler.addAnchorEffect(entity);
            MessageType.ANCHOR_ADD.sendActionbarSilently(player, (class_2561)class_2561.method_43470((String)"You anchored this villager."));
            VersionHelper.playSound(player, class_3417.field_24063, class_3419.field_15254, 1.0f, 0.5f);
            class_2338 posBelow = entity.method_24515().method_10074();
            world.method_65096((class_2394)class_2398.field_29642, entity.method_23317(), entity.method_23318(), entity.method_23321(), 10, 0.2, 0.0, 0.2, 2.0);
            world.method_65096((class_2394)new class_2388(class_2398.field_11217, world.method_8320(posBelow)), entity.method_23317(), entity.method_23318(), entity.method_23321(), 30, 0.0, 0.0, 0.0, 1.0);
        }
    }

    private void playOpenSound(class_1657 player) {
        VersionHelper.playSound(player, class_3417.field_14982, class_3419.field_15254, 1.0f, 0.8f);
    }
}

