/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.villager;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class PartnerState
extends class_18 {
    private final Map<UUID, Set<String>> partners = new HashMap<UUID, Set<String>>();

    public static Codec<PartnerState> codec(final class_3218 world) {
        return Codec.of((Encoder)new Encoder<PartnerState>(){

            public <T> DataResult<T> encode(PartnerState input, DynamicOps<T> ops, T prefix) {
                class_2487 nbtCompound = new class_2487();
                input.writeNbt(nbtCompound, (class_7225.class_7874)world.method_30349());
                return DataResult.success((Object)nbtCompound);
            }
        }, (Decoder)new Decoder<PartnerState>(){

            public <T> DataResult<Pair<PartnerState, T>> decode(DynamicOps<T> ops, T input) {
                class_2487 nbtCompound = (class_2487)ops.convertTo((DynamicOps)class_2509.field_11560, input);
                PartnerState partnerState = PartnerState.createFromNbt(nbtCompound, (class_7225.class_7874)world.method_30349());
                return DataResult.success((Object)Pair.of((Object)((Object)partnerState), (Object)ops.empty()));
            }
        });
    }

    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 registries) {
        class_2487 compound = new class_2487();
        this.partners.forEach((uuid, set) -> {
            if (set.isEmpty()) {
                return;
            }
            class_2499 list = new class_2499();
            set.forEach(partner -> list.add((Object)class_2519.method_23256((String)partner)));
            compound.method_10566(uuid.toString(), (class_2520)list);
        });
        nbt.method_10566("TradePartnerMap", (class_2520)compound);
        return nbt;
    }

    public Set<String> getPartners(UUID uuid) {
        return this.partners.computeIfAbsent(uuid, k -> new HashSet());
    }

    public boolean isPartner(UUID uuid, String partner) {
        return this.getPartners(uuid).contains(partner);
    }

    public void addPartner(UUID uuid, String partner) {
        this.getPartners(uuid).add(partner);
        this.method_80();
    }

    public void removePartner(UUID uuid, String partner) {
        this.getPartners(uuid).remove(partner);
        this.method_80();
    }

    public static PartnerState createFromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        PartnerState state = new PartnerState();
        class_2487 compound = (class_2487)nbt.method_10562("TradePartnerMap").orElseThrow();
        compound.method_10541().forEach(uuid -> {
            class_2499 list = compound.method_68569(uuid);
            Set set = state.partners.computeIfAbsent(UUID.fromString(uuid), k -> new HashSet(list.size()));
            list.forEach(nbtElement -> set.add((String)nbtElement.method_68658().orElseThrow()));
        });
        return state;
    }

    public static PartnerState getServerState(MinecraftServer server) {
        class_3218 world = server.method_3847(class_1937.field_25179);
        if (world == null) {
            throw new IllegalStateException("Overworld is null");
        }
        class_26 persistentStateManager = world.method_17983();
        class_10741 type = new class_10741("clickvillagers", PartnerState::new, PartnerState.codec(world), null);
        PartnerState state = (PartnerState)persistentStateManager.method_17924(type);
        state.method_80();
        return state;
    }
}

