/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers;

import de.clickism.clickvillagers.ClickVillagersConfig;
import de.clickism.clickvillagers.callback.CooldownManager;
import de.clickism.clickvillagers.callback.UpdateNotifier;
import de.clickism.clickvillagers.callback.UseVehicleEntityCallback;
import de.clickism.clickvillagers.callback.UseVillagerBlockCallback;
import de.clickism.clickvillagers.callback.UseVillagerEntityCallback;
import de.clickism.modrinthupdatechecker.ModrinthUpdateChecker;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3797;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickVillagers
implements ModInitializer {
    public static final String MOD_ID = "clickvillagers";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"clickvillagers");
    private static String newerVersion = null;

    public void onInitialize() {
        ClickVillagersConfig.CONFIG.load();
        CooldownManager cooldownManager = new CooldownManager(() -> (Long)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.COOLDOWN));
        UseEntityCallback.EVENT.register((Object)new UseVillagerEntityCallback(cooldownManager));
        UseEntityCallback.EVENT.register((Object)new UseVehicleEntityCallback());
        UseBlockCallback.EVENT.register((Object)new UseVillagerBlockCallback());
        if (((Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.CHECK_UPDATES)).booleanValue()) {
            this.checkUpdates();
            ServerPlayConnectionEvents.JOIN.register((Object)new UpdateNotifier(() -> newerVersion));
        }
    }

    private void checkUpdates() {
        String modVersion = FabricLoader.getInstance().getModContainer(MOD_ID).map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse(null);
        String minecraftVersion = class_3797.field_25319.comp_4025();
        new ModrinthUpdateChecker(MOD_ID, "fabric", minecraftVersion).checkVersion(version -> {
            if (modVersion == null || ModrinthUpdateChecker.getRawVersion((String)modVersion).equals(version)) {
                return;
            }
            newerVersion = version;
            LOGGER.info("Newer version available: {}", version);
        });
    }
}

