/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.gui;

import de.clickism.clickvillagers.gui.BackButton;
import de.clickism.clickvillagers.gui.VillagerGui;
import de.clickism.clickvillagers.util.VersionHelper;
import de.clickism.clickvillagers.villager.VillagerHandler;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3851;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class VillagerBiomeChangeGui
extends VillagerGui {
    private static final List<VillagerBiome> BIOMES = List.of(new VillagerBiome((class_5321<class_3854>)class_3854.field_17073, class_1802.field_17535), new VillagerBiome((class_5321<class_3854>)class_3854.field_17071, class_1802.field_8689), new VillagerBiome((class_5321<class_3854>)class_3854.field_17072, class_1802.field_17538), new VillagerBiome((class_5321<class_3854>)class_3854.field_17075, class_1802.field_8471), new VillagerBiome((class_5321<class_3854>)class_3854.field_17074, class_1802.field_17539), new VillagerBiome((class_5321<class_3854>)class_3854.field_17076, class_1802.field_17499), new VillagerBiome((class_5321<class_3854>)class_3854.field_17077, class_1802.field_17536));
    private final GuiInterface previous;

    public VillagerBiomeChangeGui(class_3222 player, VillagerHandler<?> villagerHandler, GuiInterface previous) {
        super(player, villagerHandler);
        this.previous = previous;
        this.setSlot(18, (GuiElementInterface)new BackButton(previous));
        this.setTitle((class_2561)class_2561.method_43470((String)"\ud83c\udf32 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)"Choose Villager's Biome").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})));
        this.placeBiomeButtons();
    }

    private void placeBiomeButtons() {
        int i = 10;
        for (VillagerBiome biome : BIOMES) {
            this.setSlot(i, (GuiElementInterface)this.getBiomeButton(biome.type, biome.icon));
            ++i;
        }
    }

    private GuiElement getBiomeButton(class_5321<class_3854> typeKey, class_1792 icon) {
        MinecraftServer server = this.player.method_5682();
        if (server == null) {
            return new GuiElementBuilder(icon).setName((class_2561)class_2561.method_43470((String)"Error: Server is null").method_27692(class_124.field_1061)).build();
        }
        class_6880 type = (class_6880)server.method_30611().method_30530(class_7924.field_41235).method_10223(typeKey.method_29177()).orElseThrow();
        Object villager = this.villagerHandler.getEntity();
        String biomeName = ((class_5321)type.method_40230().orElseThrow()).method_29177().method_12832().toUpperCase();
        GuiElementBuilder builder = new GuiElementBuilder(icon).setName((class_2561)class_2561.method_43470((String)biomeName).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).addLoreLine((class_2561)class_2561.method_43470((String)"Click to change the villager's biome.").method_27692(class_124.field_1077)).setCallback((index, t, action, gui) -> {
            if (villager.method_31481()) {
                return;
            }
            ((class_3851)villager).method_7195(((class_3851)villager).method_7231().method_16922(type));
            VersionHelper.playSound((class_1657)this.player, class_3417.field_17608, class_3419.field_15250, 1.0f, 0.5f);
            VersionHelper.playSound((class_1657)this.player, class_3417.field_28558, class_3419.field_15250, 1.0f, 1.0f);
            VersionHelper.playSound((class_1657)this.player, class_3417.field_28563, class_3419.field_15250, 1.0f, 2.0f);
            this.placeBiomeButtons();
        });
        if (((class_3851)villager).method_7231().comp_3520().equals((Object)type)) {
            builder.glow();
        }
        return builder.build();
    }

    private record VillagerBiome(class_5321<class_3854> type, class_1792 icon) {
    }
}

