/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.gui;

import de.clickism.clickvillagers.ClickVillagersConfig;
import de.clickism.clickvillagers.gui.BackButton;
import de.clickism.clickvillagers.gui.VillagerEditGui;
import de.clickism.clickvillagers.gui.VillagerGui;
import de.clickism.clickvillagers.util.MessageType;
import de.clickism.clickvillagers.util.VersionHelper;
import de.clickism.clickvillagers.villager.PartnerState;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class VillagerPartnerGui
extends AnvilInputGui {
    private final MinecraftServer server;
    private final VillagerGui previous;

    public VillagerPartnerGui(class_3222 player, VillagerGui previous) {
        super(player, false);
        this.server = VersionHelper.getServer((class_1297)player);
        this.previous = previous;
        if (this.server == null) {
            throw new IllegalStateException("Server is null");
        }
        this.setTitle((class_2561)class_2561.method_43470((String)"\u270d ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)"Add Partner").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})));
        this.setSlot(2, (GuiElementInterface)this.getConfirmButton(this.getInput()));
        this.setSlot(1, (GuiElementInterface)new BackButton((GuiInterface)previous));
        this.setSlot(0, (GuiElementInterface)new GuiElementBuilder(class_1802.field_8575).build());
        this.setDefaultInputValue("");
    }

    public void onInput(String input) {
        this.setSlot(2, (GuiElementInterface)this.getConfirmButton(input));
    }

    private GuiElement getConfirmButton(String input) {
        GuiElementBuilder builder = new GuiElementBuilder(class_1802.field_8782).setName((class_2561)class_2561.method_43470((String)"\u270d ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)"ADD PARTNER").method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}))).setCallback((index, type, action, gui) -> {
            UUID uuid;
            if (!this.isValid(input)) {
                MessageType.FAIL.playSound((class_1657)this.player);
                return;
            }
            PartnerState partnerState = PartnerState.getServerState(this.server);
            if (partnerState.isPartner(uuid = this.player.method_5667(), input)) {
                partnerState.removePartner(uuid, input);
                MessageType.WARN.send((class_1657)this.player, (class_2561)class_2561.method_43470((String)("Removed " + input + " from your trading partners.")));
            } else {
                int limit = (Integer)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.PARTNER_LIMIT_PER_PLAYER);
                if (partnerState.getPartners(uuid).size() >= limit) {
                    MessageType.FAIL.send((class_1657)this.player, (class_2561)class_2561.method_43470((String)"You have reached the partner limit: ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(limit)).method_27692(class_124.field_1067)));
                    return;
                }
                partnerState.addPartner(uuid, input);
                MessageType.CONFIRM.send((class_1657)this.player, (class_2561)class_2561.method_43470((String)("Added " + input + " to your trading partners.")));
            }
            new VillagerEditGui(this.player, this.previous.villagerHandler).open();
        });
        if (this.isPartner(input)) {
            builder.setItem(class_1802.field_8077).setName((class_2561)class_2561.method_43470((String)"\u270d ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"REMOVE PARTNER").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}))).addLoreLine((class_2561)class_2561.method_43470((String)("Click to remove \"" + input + "\" from your trading partners.")).method_27692(class_124.field_1061));
        } else {
            builder.setName((class_2561)class_2561.method_43470((String)"\u270d ").method_27692(class_124.field_1077).method_10852((class_2561)class_2561.method_43470((String)"ADD PARTNER").method_27695(new class_124[]{class_124.field_1077, class_124.field_1067}))).addLoreLine((class_2561)class_2561.method_43470((String)("Click to add \"" + input + "\" to your trading partners.")).method_27692(class_124.field_1060));
        }
        return builder.build();
    }

    private boolean isPartner(String input) {
        PartnerState partnerState = PartnerState.getServerState(this.server);
        return partnerState.getPartners(this.player.method_5667()).contains(input);
    }

    private boolean isValid(String input) {
        return input.length() > 2 && !input.contains(" ");
    }
}

