/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.villager;

import de.clickism.clickvillagers.ClickVillagersConfig;
import de.clickism.clickvillagers.anchor.AnchorHandler;
import de.clickism.clickvillagers.util.MessageType;
import de.clickism.clickvillagers.util.NbtFixer;
import de.clickism.clickvillagers.util.Utils;
import de.clickism.clickvillagers.util.VersionHelper;
import de.clickism.clickvillagers.villager.TradeInfoProvider;
import de.clickism.clickvillagers.villager.TradeInfoProviders;
import de.clickism.clickvillagers.villager.VillagerHandler;
import de.clickism.clickvillagers.villager.VillagerTextures;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_155;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1915;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3851;
import net.minecraft.class_3852;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PickupHandler {
    private static final String TYPE_KEY = "EntityType";
    private static final String DATA_VERSION_KEY = "CVDataVersion";
    private static final int DATA_VERSION = class_155.method_16673().comp_4026().comp_4038();

    public static <T extends class_1309> class_1799 toItemStack(T entity) {
        class_11362 view = class_11362.method_71459((class_8942)new class_8942.class_8943(), (class_7225.class_7874)VersionHelper.getWorld(entity).method_30349());
        entity.method_5647((class_11372)view);
        String id = class_1299.method_5890((class_1299)entity.method_5864()).toString();
        view.method_71469(TYPE_KEY, id);
        view.method_71469(DATA_VERSION_KEY, String.valueOf(DATA_VERSION));
        List<class_2561> lore = PickupHandler.getLore(new VillagerHandler<T>(entity));
        class_5250 displayName = PickupHandler.getDisplayName(entity);
        class_1799 itemStack = PickupHandler.getItemStack((class_2561)displayName, lore, view);
        VillagerTextures.setEntityTexture(itemStack, entity);
        entity.method_5650(class_1297.class_5529.field_26999);
        return itemStack;
    }

    private static class_1799 getItemStack(class_2561 name, List<class_2561> lore, class_11362 nbt) {
        class_1799 itemStack = class_1802.field_8575.method_7854();
        PickupHandler.writeCustomData(itemStack, nbt);
        PickupHandler.formatItem(itemStack, (class_2561)name.method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054)), lore);
        return itemStack;
    }

    private static List<class_2561> getLore(VillagerHandler<?> villager) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add((class_2561)class_2561.method_43470((String)"Right click to place the villager back.").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1063));
        Object entity = villager.getEntity();
        if (villager.hasOwner()) {
            UUID ownerUuid = villager.getOwner();
            MinecraftServer server = VersionHelper.getServer(entity);
            String ownerName = server != null ? VersionHelper.getPlayerName(ownerUuid, server).orElse("?") : "?";
            lore.add((class_2561)class_2561.method_43470((String)"\ud83d\udd11 Owner: ").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)ownerName).method_27692(class_124.field_1070).method_27692(class_124.field_1068)));
        }
        if (AnchorHandler.isAnchored(entity)) {
            lore.add((class_2561)class_2561.method_43470((String)"\u2693 Anchored").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1062));
        }
        if (!villager.isTradingOpen()) {
            lore.add((class_2561)class_2561.method_43470((String)"\ud83d\udc65 Trading Closed").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1061));
        }
        if (entity instanceof class_1915) {
            class_1915 merchant = (class_1915)entity;
            if (entity instanceof class_3851) {
                class_3851 container = (class_3851)entity;
                if (!merchant.method_8264().isEmpty() && ((Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.SHOW_TRADES)).booleanValue()) {
                    class_5321 profession = (class_5321)container.method_7231().comp_3521().method_40230().orElseThrow();
                    TradeInfoProvider provider = (Boolean)ClickVillagersConfig.CONFIG.get(ClickVillagersConfig.FORMAT_TRADES) != false ? TradeInfoProviders.getProvider((class_5321<class_3852>)profession) : TradeInfoProviders.ALL_TRADES;
                    List<String> tradeInfoLines = provider.getTradeInfoLines(merchant.method_8264());
                    if (!tradeInfoLines.isEmpty()) {
                        lore.add((class_2561)class_2561.method_43470((String)" "));
                        lore.add((class_2561)class_2561.method_43470((String)"\ud83d\udecd Trades:").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080));
                        tradeInfoLines.forEach(line -> lore.add((class_2561)class_2561.method_43470((String)line)));
                    }
                }
            }
        }
        return lore;
    }

    private static void writeCustomData(class_1799 itemStack, class_11362 view) {
        itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)view.method_71475()));
    }

    @Nullable
    private static class_2487 readCustomData(class_1799 itemStack) {
        class_9279 nbt = (class_9279)itemStack.method_58694(class_9334.field_49628);
        if (nbt == null) {
            return null;
        }
        return nbt.method_57461();
    }

    private static void formatItem(class_1799 itemStack, class_2561 name, List<class_2561> lore) {
        itemStack.method_57379(class_9334.field_50239, (Object)name);
        itemStack.method_57379(class_9334.field_49631, (Object)name);
        itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
    }

    public static boolean isVillager(class_1799 itemStack) {
        return PickupHandler.readCustomData(itemStack) != null;
    }

    @Nullable
    public static class_1297 readEntityFromItemStack(class_1937 world, class_1799 itemStack) {
        try {
            class_2487 nbt = PickupHandler.readCustomData(itemStack);
            if (nbt == null) {
                return null;
            }
            MinecraftServer server = world.method_8503();
            if (server == null) {
                return null;
            }
            NbtFixer.applyDataFixes(nbt);
            String id = (String)nbt.method_10558(TYPE_KEY).orElseThrow();
            if (id == null) {
                return null;
            }
            class_1299 type = class_1299.method_5898((String)id).orElse(null);
            if (type == null) {
                return null;
            }
            class_1297 entity = type.method_5883(world, class_3730.field_16465);
            if (entity == null) {
                return null;
            }
            class_11368 view = class_11352.method_71417((class_8942)new class_8942.class_8943(), (class_7225.class_7874)world.method_30349(), (class_2487)nbt);
            entity.method_5651(view);
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class_5250 getDisplayName(class_1297 entity) {
        if (entity.method_16914()) {
            return class_2561.method_43470((String)"\"").method_10852(entity.method_5797()).method_27693("\"");
        }
        if (entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            return PickupHandler.getVillagerDisplayName(villager);
        }
        if (entity instanceof class_1641) {
            return class_2561.method_43470((String)"Zombie Villager");
        }
        return class_2561.method_43470((String)"Unknown");
    }

    private static class_5250 getVillagerDisplayName(class_1646 villager) {
        if (villager.method_6109()) {
            return class_2561.method_43470((String)"Baby Villager");
        }
        class_6880 profession = villager.method_7231().comp_3521();
        String professionName = ((class_5321)profession.method_40230().orElseThrow()).method_29177().method_12832();
        if (profession.method_40225(class_3852.field_17051)) {
            return class_2561.method_43470((String)"Villager");
        }
        return class_2561.method_43470((String)(Utils.titleCase(professionName) + " Villager"));
    }

    public static void notifyPickup(class_1657 player, class_1297 entity) {
        MessageType.PICKUP_MESSAGE.sendActionbarSilently(player, (class_2561)class_2561.method_43470((String)"You picked up a villager"));
        class_3218 world = (class_3218)VersionHelper.getWorld(entity);
        double x = entity.method_23317();
        double y = entity.method_23318() + 0.25;
        double z = entity.method_23321();
        world.method_65096((class_2394)class_2398.field_11227, x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
        VersionHelper.playSound(player, class_3417.field_14706, class_3419.field_15254, 1.0f, 0.5f);
    }
}

