/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.villager;

import de.clickism.clickvillagers.util.Utils;
import de.clickism.clickvillagers.util.VersionHelper;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class TradeInfoProvider {
    private static final String LINE_FORMAT = "   \u00a78\u2192 \u00a77%s \u00a78\u2192 \u00a77%s";
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\n");
    private final Predicate<class_1799> ingredientsFilter;
    private final Predicate<class_1799> resultsFilter;
    private final Function<class_1799, String> ingredientFormatter;
    private final Function<class_1799, String> resultFormatter;
    private final boolean formatEnchantments;
    private static final String SINGLE_SPACING = " ".repeat(26);
    private static final String DOUBLE_SPACING = " ".repeat(27);

    public TradeInfoProvider(Predicate<class_1799> ingredientsFilter, Predicate<class_1799> resultsFilter, Function<class_1799, String> ingredientFormatter, Function<class_1799, String> resultFormatter, boolean formatEnchantments) {
        this.ingredientsFilter = ingredientsFilter;
        this.resultsFilter = resultsFilter;
        this.ingredientFormatter = ingredientFormatter;
        this.resultFormatter = resultFormatter;
        this.formatEnchantments = formatEnchantments;
    }

    public List<String> getTradeInfoLines(class_1916 offers) {
        return offers.stream().filter(offer -> this.ingredientsFilter.test(VersionHelper.getFirstBuyItem(offer)) || this.resultsFilter.test(VersionHelper.getSecondBuyItem(offer)) || this.resultsFilter.test(offer.method_8250())).map(this::formatRecipe).flatMap(LINE_BREAK_PATTERN::splitAsStream).toList();
    }

    private String formatRecipe(class_1914 offer) {
        String ingredients = Stream.of(VersionHelper.getFirstBuyItem(offer), VersionHelper.getSecondBuyItem(offer)).filter(item -> !item.method_31574(class_1802.field_8162)).map(this.ingredientFormatter).filter(Objects::nonNull).collect(Collectors.joining(" + "));
        String result = this.resultFormatter.apply(offer.method_8250());
        Object line = TradeInfoProvider.formatLine(ingredients, result);
        if (this.formatEnchantments) {
            line = (String)line + TradeInfoProvider.formatEnchantments(offer);
        }
        return line;
    }

    private static String formatLine(String ingredients, String result) {
        return String.format(LINE_FORMAT, ingredients, result);
    }

    private static String formatEnchantments(class_1914 offer) {
        String spacing = TradeInfoProvider.getSpacing(offer);
        class_1799 item = offer.method_8250();
        return item.method_58657().method_57539().stream().map(entry -> {
            String enchantment = ((class_6880)entry.getKey()).method_40230().map(class_5321::method_29177).map(class_2960::method_12832).map(s -> s.replace("_", " ")).orElse("?");
            String level = Utils.toRomanNumeral(entry.getIntValue());
            return "\n" + spacing + "\u00a77" + Utils.titleCase(enchantment) + " " + level;
        }).collect(Collectors.joining());
    }

    private static String getSpacing(class_1914 offer) {
        int emeraldCount = Stream.of(VersionHelper.getFirstBuyItem(offer), VersionHelper.getSecondBuyItem(offer)).filter(item -> item.method_31574(class_1802.field_8687)).mapToInt(class_1799::method_7947).sum();
        if (emeraldCount == 0) {
            return "";
        }
        return emeraldCount < 10 ? SINGLE_SPACING : DOUBLE_SPACING;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Predicate<class_1799> ingredientsFilter = item -> false;
        private Predicate<class_1799> resultsFilter = item -> false;
        private Function<class_1799, String> ingredientFormatter = Utils::formatItem;
        private Function<class_1799, String> resultFormatter = Utils::formatItem;
        private boolean formatEnchantments = false;

        private Builder() {
        }

        public Builder filterIngredients(Predicate<class_1799> ingredientsFilter) {
            this.ingredientsFilter = ingredientsFilter;
            return this;
        }

        public Builder acceptIngredients(class_1792 ... ingredients) {
            Set<class_1792> ingredientsSet = Set.of(ingredients);
            this.ingredientsFilter = item -> ingredientsSet.contains(item.method_7909());
            return this;
        }

        public Builder filterResults(Predicate<class_1799> resultsFilter) {
            this.resultsFilter = resultsFilter;
            return this;
        }

        public Builder acceptResults(class_1792 ... results) {
            Set<class_1792> resultSet = Set.of(results);
            this.resultsFilter = item -> resultSet.contains(item.method_7909());
            return this;
        }

        public Builder ingredientFormatter(Function<class_1799, String> ingredientFormatter) {
            this.ingredientFormatter = ingredientFormatter;
            return this;
        }

        public Builder resultFormatter(Function<class_1799, String> resultFormatter) {
            this.resultFormatter = resultFormatter;
            return this;
        }

        public Builder singleFormatter(Function<class_1799, String> itemFormatter) {
            this.ingredientFormatter = itemFormatter;
            this.resultFormatter = itemFormatter;
            return this;
        }

        public Builder formatEnchantments() {
            this.formatEnchantments = true;
            return this;
        }

        public TradeInfoProvider build() {
            return new TradeInfoProvider(this.ingredientsFilter, this.resultsFilter, this.ingredientFormatter, this.resultFormatter, this.formatEnchantments);
        }
    }
}

