/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.callback;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1657;

public class CooldownManager {
    private final Supplier<Long> cooldownMillisSupplier;
    private final HashMap<UUID, Long> lastUseMap = new HashMap();

    public CooldownManager(Supplier<Long> cooldownMillisSupplier) {
        this.cooldownMillisSupplier = cooldownMillisSupplier;
    }

    public boolean hasCooldown(class_1657 player) {
        return this.getRemainingCooldownMillis(player) > 0L;
    }

    public long getRemainingCooldownSeconds(class_1657 player) {
        return (long)Math.ceil((double)this.getRemainingCooldownMillis(player) / 1000.0);
    }

    public long getRemainingCooldownMillis(class_1657 player) {
        long cooldownMillis = this.cooldownMillisSupplier.get();
        if (cooldownMillis <= 0L) {
            return 0L;
        }
        long time = System.currentTimeMillis();
        Long lastUse = this.lastUseMap.get(player.method_5667());
        if (lastUse == null) {
            return 0L;
        }
        long passedMillis = time - lastUse;
        return cooldownMillis - passedMillis;
    }

    public void giveCooldown(class_1657 player) {
        this.lastUseMap.put(player.method_5667(), System.currentTimeMillis());
    }
}

