/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickvillagers.villager;

import de.clickism.clickvillagers.util.Utils;
import de.clickism.clickvillagers.villager.TradeInfoProvider;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TradeInfoProviders {
    private static final Function<class_1799, String> ITEM_FORMATTER = stack -> {
        class_1792 item = stack.method_7909();
        Object prefix = TradeInfoProviders.getPrefix(item);
        prefix = prefix == null ? "" : (String)prefix + " ";
        boolean isTool = !stack.method_7946();
        String name = isTool ? Utils.formatItem(item) : Utils.formatItem(stack);
        return (String)prefix + name;
    };
    public static final TradeInfoProvider ALL_TRADES = TradeInfoProvider.builder().filterIngredients(item -> true).filterResults(item -> true).build();
    public static final TradeInfoProvider LIBRARIAN = TradeInfoProvider.builder().acceptResults(class_1802.field_8598).ingredientFormatter(item -> {
        if (!item.method_31574(class_1802.field_8687)) {
            return null;
        }
        return item.method_7947() + " Emerald";
    }).resultFormatter(TradeInfoProviders::formatEnchantedBook).build();
    public static final TradeInfoProvider FARMER = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8861, class_1802.field_8186, class_1802.field_8179, class_1802.field_8567, class_1802.field_17518, class_1802.field_17522).acceptResults(class_1802.field_8071, class_1802.field_8279, class_1802.field_8229).singleFormatter(ITEM_FORMATTER).build();
    public static final TradeInfoProvider SMITH = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8713).acceptResults(class_1802.field_8556, class_1802.field_8377, class_1802.field_8250, class_1802.field_8527, class_1802.field_8802, class_1802.field_8805, class_1802.field_8058, class_1802.field_8348, class_1802.field_8285, class_1802.field_8255).singleFormatter(ITEM_FORMATTER).formatEnchantments().build();
    public static final TradeInfoProvider BUTCHER = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8726, class_1802.field_8389, class_1802.field_8504, class_1802.field_16998, class_1802.field_17532).acceptResults(class_1802.field_8544, class_1802.field_8261).singleFormatter(ITEM_FORMATTER).build();
    public static final TradeInfoProvider FISHERMAN = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8276, class_1802.field_8713).acceptResults(class_1802.field_17346, class_1802.field_8378).singleFormatter(ITEM_FORMATTER).formatEnchantments().build();
    public static final TradeInfoProvider LEATHERWORKER = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8745, class_1802.field_8145, class_1802.field_8245, class_1802.field_8161).acceptResults(class_1802.field_18138, class_1802.field_8175).singleFormatter(ITEM_FORMATTER).build();
    public static final TradeInfoProvider CLERIC = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8695).acceptResults(class_1802.field_8725, class_1802.field_8759, class_1802.field_8801, class_1802.field_8634, class_1802.field_8287).singleFormatter(ITEM_FORMATTER).build();
    public static final TradeInfoProvider CARTOGRAPHER = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8407).acceptResults(class_1802.field_8143, class_1802.field_8895).singleFormatter(ITEM_FORMATTER).build();
    public static final TradeInfoProvider FLETCHER = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8600, class_1802.field_8145, class_1802.field_8276).filterResults(item -> {
        class_1792 itemType = item.method_7909();
        if (itemType == class_1802.field_8107) {
            return true;
        }
        if (itemType == class_1802.field_8102) {
            return !item.method_58657().method_57543();
        }
        return false;
    }).singleFormatter(ITEM_FORMATTER).formatEnchantments().build();
    public static final TradeInfoProvider MASON = TradeInfoProvider.builder().acceptIngredients(class_1802.field_8696, class_1802.field_8155).acceptResults(class_1802.field_8621, class_1802.field_8746, class_1802.field_20402, class_1802.field_8260, class_1802.field_8156, class_1802.field_8043, class_1802.field_8783, class_1802.field_8717, class_1802.field_8385, class_1802.field_8672, class_1802.field_8853, class_1802.field_8304, class_1802.field_8133, class_1802.field_8821, class_1802.field_8715, class_1802.field_8455, class_1802.field_8467, class_1802.field_8798, class_1802.field_8353, class_1802.field_8181, class_1802.field_8177, class_1802.field_8139, class_1802.field_8318, class_1802.field_8640, class_1802.field_8889, class_1802.field_8649, class_1802.field_8277, class_1802.field_8885, class_1802.field_8172, class_1802.field_8257, class_1802.field_8562, class_1802.field_8484, class_1802.field_8394, class_1802.field_8244, class_1802.field_8870, class_1802.field_8096).ingredientFormatter(ITEM_FORMATTER).resultFormatter(item -> {
        class_1792 material = item.method_7909();
        if (material == class_1802.field_8621 || material == class_1802.field_8746 || material == class_1802.field_20402 || material == class_1802.field_8687) {
            return ITEM_FORMATTER.apply((class_1799)item);
        }
        return "\u00a76\ud83e\udea8 " + Utils.formatItem(item);
    }).build();
    public static final TradeInfoProvider SHEPHERD = TradeInfoProvider.builder().acceptIngredients(class_1802.field_19044, class_1802.field_19056, class_1802.field_19059, class_1802.field_19051).acceptResults(class_1802.field_8868, class_1802.field_8892).singleFormatter(ITEM_FORMATTER).build();
    private static final Map<class_5321<class_3852>, TradeInfoProvider> PROVIDERS = Map.ofEntries(Map.entry(class_3852.field_17060, LIBRARIAN), Map.entry(class_3852.field_17056, FARMER), Map.entry(class_3852.field_17064, SMITH), Map.entry(class_3852.field_17065, SMITH), Map.entry(class_3852.field_17052, SMITH), Map.entry(class_3852.field_17053, BUTCHER), Map.entry(class_3852.field_17057, FISHERMAN), Map.entry(class_3852.field_17059, LEATHERWORKER), Map.entry(class_3852.field_17055, CLERIC), Map.entry(class_3852.field_17054, CARTOGRAPHER), Map.entry(class_3852.field_17058, FLETCHER), Map.entry(class_3852.field_17061, MASON), Map.entry(class_3852.field_17063, SHEPHERD));
    private static final Map<class_1792, String> PREFIX_MAP = Map.ofEntries(Map.entry(class_1802.field_8598, "\u00a7d\ud83d\udcd6"), Map.entry(class_1802.field_8071, "\u00a7e\ud83e\udd55"), Map.entry(class_1802.field_8279, "\u00a7c\ud83c\udf4e"), Map.entry(class_1802.field_8861, "\u00a7e\ud83c\udf3e"), Map.entry(class_1802.field_8179, "\u00a76\ud83e\udd55"), Map.entry(class_1802.field_8567, "\u00a76\ud83e\udd54"), Map.entry(class_1802.field_17518, "\u00a76\ud83c\udf83"), Map.entry(class_1802.field_17522, "\u00a7a\ud83c\udf49"), Map.entry(class_1802.field_8713, "\u00a78\ud83e\udea8"), Map.entry(class_1802.field_8145, "\u00a78\ud83e\udea8"), Map.entry(class_1802.field_8802, "\u00a7b\ud83d\udde1"), Map.entry(class_1802.field_8556, "\u00a7b\u26cf"), Map.entry(class_1802.field_8377, "\u00a7b\u26cf"), Map.entry(class_1802.field_8250, "\u00a7b\u26cf"), Map.entry(class_1802.field_8527, "\u00a7b\u26cf"), Map.entry(class_1802.field_8805, "\u00a7b\ud83d\udc55"), Map.entry(class_1802.field_8058, "\u00a7b\ud83d\udc55"), Map.entry(class_1802.field_8348, "\u00a7b\ud83d\udc55"), Map.entry(class_1802.field_8285, "\u00a7b\ud83d\udc55"), Map.entry(class_1802.field_8726, "\u00a7e\ud83d\udc13"), Map.entry(class_1802.field_8389, "\u00a7e\ud83d\udc37"), Map.entry(class_1802.field_8504, "\u00a7e\ud83d\udc30"), Map.entry(class_1802.field_16998, "\u00a7c\ud83c\udf47"), Map.entry(class_1802.field_17532, "\u00a7a\ud83c\udf3f"), Map.entry(class_1802.field_8544, "\u00a76\ud83d\udc13"), Map.entry(class_1802.field_8261, "\u00a76\ud83d\udc37"), Map.entry(class_1802.field_8276, "\u00a7f\ud83e\udea1"), Map.entry(class_1802.field_17346, "\u00a7c\ud83d\udd25"), Map.entry(class_1802.field_8378, "\u00a76\ud83c\udfa3"), Map.entry(class_1802.field_8255, "\u00a76\u26e8"), Map.entry(class_1802.field_8745, "\u00a76\ud83d\udc04"), Map.entry(class_1802.field_8245, "\u00a7e\ud83d\udc07"), Map.entry(class_1802.field_8161, "\u00a7a\ud83d\udc22"), Map.entry(class_1802.field_8175, "\u00a76\ud83d\udc34"), Map.entry(class_1802.field_8725, "\u00a7c\ud83d\udc8e"), Map.entry(class_1802.field_8695, "\u00a76\ud83d\udc8e"), Map.entry(class_1802.field_8759, "\u00a79\ud83d\udc8e"), Map.entry(class_1802.field_8801, "\u00a7e\ud83c\udf1f"), Map.entry(class_1802.field_8634, "\u00a73\u25ce"), Map.entry(class_1802.field_8287, "\u00a7d\ud83e\uddea"), Map.entry(class_1802.field_8407, "\u00a7f\ud83d\udcc4"), Map.entry(class_1802.field_8895, "\u00a7e\ud83d\udcc4"), Map.entry(class_1802.field_8143, "\u00a76\ud83d\uddbc"), Map.entry(class_1802.field_8892, "\u00a76\ud83d\uddbc"), Map.entry(class_1802.field_8600, "\u00a76\ud83e\ude83"), Map.entry(class_1802.field_8107, "\u00a7f\u27b5"), Map.entry(class_1802.field_8102, "\u00a76\ud83c\udff9"), Map.entry(class_1802.field_8696, "\u00a73\ud83e\udea8"), Map.entry(class_1802.field_8621, "\u00a7c\ud83e\uddf1"), Map.entry(class_1802.field_8155, "\u00a7f\ud83d\udc8e"), Map.entry(class_1802.field_20402, "\u00a7f\ud83d\udc8e"), Map.entry(class_1802.field_8746, "\u00a7f\ud83d\udc8e"), Map.entry(class_1802.field_19044, "\u00a7f\ud83e\uddf6"), Map.entry(class_1802.field_19056, "\u00a76\ud83e\uddf6"), Map.entry(class_1802.field_19059, "\u00a78\ud83e\uddf6"), Map.entry(class_1802.field_19051, "\u00a77\ud83e\uddf6"), Map.entry(class_1802.field_8868, "\u00a7c\u2702"));

    public static TradeInfoProvider getProvider(class_5321<class_3852> profession) {
        return PROVIDERS.getOrDefault(profession, ALL_TRADES);
    }

    @Nullable
    private static String getPrefix(class_1792 item) {
        return PREFIX_MAP.get(item);
    }

    private static String formatEnchantedBook(class_1799 item) {
        class_9304 enchants = (class_9304)item.method_58694(class_9334.field_49643);
        if (enchants == null) {
            return "";
        }
        String enchantments = enchants.method_57539().stream().map(entry -> {
            String enchantment = ((class_6880)entry.getKey()).method_40230().map(class_5321::method_29177).map(class_2960::method_12832).map(s -> s.replace("_", " ")).orElse("?");
            String level = Utils.toRomanNumeral(entry.getIntValue());
            return Utils.titleCase(enchantment) + " " + level;
        }).collect(Collectors.joining(" + "));
        return "\u00a7d\ud83d\udcd6 " + enchantments;
    }
}

