/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.imagetitles;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.alejandrocoria.imagetitles.Constants;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_6328;
import net.minecraft.class_746;
import net.minecraft.class_7677;

public class ImageTitles {
    private static final String EXTENSION_V1 = ".png.mcdata";
    private static final Map<String, TitleData> images = new HashMap<String, TitleData>();
    private static TitleData current = null;
    private static boolean needAnnounceDeprecated = false;

    public static void init() {
        Constants.LOG.info("imageTitles init");
    }

    public static void loadImageFiles(class_3300 resourceManager) {
        ImageTitles.clearAllImages();
        ArrayList files = new ArrayList(resourceManager.method_14488("textures/title", path -> path.method_12832().endsWith(EXTENSION_V1) || path.method_12832().endsWith(".png")).keySet());
        ArrayList<class_2960> v1Resources = new ArrayList<class_2960>();
        Gson gson = new Gson();
        for (class_2960 location : files) {
            try {
                class_3298 resource = resourceManager.getResourceOrThrow(location);
                class_2960 imagePath = class_2960.method_60655((String)location.method_12836(), (String)location.method_12832().replace(EXTENSION_V1, ".png"));
                if (location.method_12832().endsWith(EXTENSION_V1)) {
                    TitleJson titleJson = (TitleJson)gson.fromJson((Reader)resource.method_43039(), TitleJson.class);
                    v1Resources.add(location);
                    images.put(titleJson.title, new TitleData(imagePath, titleJson.x, titleJson.y, titleJson.width, titleJson.height));
                    continue;
                }
                Optional metadataOpt = resource.method_14481().method_43041(ImageTitlesMetadataSection.TYPE);
                metadataOpt.ifPresent(metadata -> images.put(metadata.title, new TitleData(imagePath, metadata.x, metadata.y, metadata.width, metadata.height)));
            }
            catch (IOException e) {
                Constants.LOG.error("Error loading file \"{}\": {}", (Object)location, (Object)e);
            }
            catch (JsonSyntaxException e) {
                Constants.LOG.error("Error loading json data in file \"{}\": {}", (Object)location, (Object)e);
            }
        }
        if (!v1Resources.isEmpty()) {
            needAnnounceDeprecated = true;
            Constants.LOG.warn("Resources with metadata in .mcdata files were detected. This is deprecated; please upgrade to version 2: https://github.com/alejandrocoria/ImageTitles-Example");
            Constants.LOG.warn("Resources: {}", v1Resources);
        }
    }

    public static void announceDeprecated() {
        class_746 player;
        if (needAnnounceDeprecated && (player = class_310.method_1551().field_1724) != null) {
            class_5250 prefix = class_2561.method_43470((String)"ImageTitles: ").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(-256));
            class_5250 message = class_2561.method_43470((String)"Resources with metadata in .mcdata files were detected. This is deprecated; please upgrade to version 2: ").method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(-1));
            class_5250 button = class_2561.method_43470((String)"https://github.com/alejandrocoria/ImageTitles-Example");
            button.method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10982(Boolean.valueOf(false)).method_36139(-1));
            button.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create("https://github.com/alejandrocoria/ImageTitles-Example"))));
            player.method_7353((class_2561)prefix.method_10852((class_2561)message).method_10852((class_2561)button), false);
            needAnnounceDeprecated = false;
        }
    }

    public static void setCurrent(class_2561 title) {
        current = images.get(title.getString());
    }

    public static void clearAllImages() {
        images.clear();
        current = null;
    }

    public static boolean renderImage(class_332 guiGraphics, int alpha) {
        if (current == null) {
            return false;
        }
        guiGraphics.method_51448().pushMatrix();
        float guiScale = class_310.method_1551().method_22683().method_4495();
        guiGraphics.method_51448().scale(1.0f / guiScale, 1.0f / guiScale);
        int color = 0xFFFFFF | alpha << 24;
        int width = ImageTitles.current.width;
        int height = ImageTitles.current.height;
        int x = (int)((float)guiGraphics.method_51421() * guiScale * ImageTitles.current.x - (float)width / 2.0f);
        int y = (int)((float)guiGraphics.method_51443() * guiScale * ImageTitles.current.y - (float)height / 2.0f);
        guiGraphics.method_25291(class_10799.field_56883, ImageTitles.current.texture, x, y, 0.0f, 0.0f, width, height, width, height, color);
        guiGraphics.method_51448().popMatrix();
        return true;
    }

    static class TitleJson {
        String title;
        float x = 0.5f;
        float y = 0.25f;
        int width;
        int height;

        TitleJson() {
        }
    }

    static class TitleData {
        public class_2960 texture;
        float x;
        float y;
        public int width;
        public int height;

        public TitleData(class_2960 texture, float x, float y, int width, int height) {
            this.texture = texture;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    @class_6328
    record ImageTitlesMetadataSection(String title, float x, float y, int width, int height) {
        public static final Codec<ImageTitlesMetadataSection> CODEC = RecordCodecBuilder.create(p_377176_ -> p_377176_.group((App)Codec.STRING.fieldOf("title").forGetter(ImageTitlesMetadataSection::title), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.5f)).forGetter(ImageTitlesMetadataSection::x), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.25f)).forGetter(ImageTitlesMetadataSection::y), (App)Codec.INT.fieldOf("width").forGetter(ImageTitlesMetadataSection::width), (App)Codec.INT.fieldOf("height").forGetter(ImageTitlesMetadataSection::height)).apply((Applicative)p_377176_, ImageTitlesMetadataSection::new));
        public static final class_7677<ImageTitlesMetadataSection> TYPE = new class_7677("imagetitles", CODEC);
    }
}

