package me.drex.message.impl;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_8824;
import net.minecraft.network.chat.*;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class MessageImpl implements class_7417 {

    private final String key;
    private final Map<String, class_2561> placeholders;
    @Nullable
    private final PlaceholderContext staticContext;

    public static final MapCodec<MessageImpl> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
        Codec.STRING.fieldOf("key").forGetter(MessageImpl::getKey),
        Codec.unboundedMap(Codec.STRING, class_8824.field_46597).optionalFieldOf("placeholders", Map.of()).forGetter(MessageImpl::getPlaceholders)
    ).apply(instance, (key, placeholders) -> new MessageImpl(key, placeholders, null)));
    public static final class_7417.class_8823<MessageImpl> TYPE = new class_7417.class_8823<>(CODEC, "message");

    public MessageImpl(String key, Map<String, class_2561> placeholders, @Nullable PlaceholderContext staticContext) {
        this.key = key;
        this.placeholders = placeholders;
        this.staticContext = staticContext;
    }

    public class_5250 parseMessage(MinecraftServer server, @Nullable PlaceholderContext dynamicContext) {
        PlaceholderContext context;
        context = Objects.requireNonNullElseGet(this.staticContext, () -> Objects.requireNonNullElseGet(dynamicContext, () -> PlaceholderContext.of(server)));
        TextNode node = LanguageManager.resolveMessageId(context.player(), this.key);
        Map<String, class_2561> parsedPlaceholders = new HashMap<>();
        if (this.placeholders != null) {
            this.placeholders.forEach((key1, value) -> parsedPlaceholders.put(key1, parseComponent(value, dynamicContext)));
        }
        return (class_5250) node.toText(context.asParserContext().with(LanguageManager.PLACEHOLDERS, parsedPlaceholders::get), true);
    }

    public static class_2561 parseComponent(class_2561 component, PlaceholderContext context) {
        class_7417 contents = component.method_10851();
        if (!(contents instanceof MessageImpl message)) {
            return component;
        }
        class_5250 parsedMessage = message.parseMessage(MessageMod.SERVER_INSTANCE, context);
        for (class_2561 sibling : component.method_10855()) {
            parsedMessage.method_10852(parseComponent(sibling, context));
        }
        parsedMessage.method_10862(parsedMessage.method_10866().method_27702(component.method_10866()));
        return parsedMessage;
    }

    @Override
    public <T> @NotNull Optional<T> method_27660(class_5348.class_5246<T> styledContentConsumer, class_2583 style) {
        try {
            return method_10890(null, null, 0).method_27658(styledContentConsumer, style);
        } catch (Throwable e) {
            return Optional.empty();
        }
    }

    @Override
    public <T> @NotNull Optional<T> method_27659(class_5348.class_5245<T> contentConsumer) {
        try {
            return method_10890(null, null, 0).method_27657(contentConsumer);
        } catch (Throwable e) {
            return Optional.empty();
        }
    }

    @Override
    public @NotNull class_5250 method_10890(@Nullable class_2168 src, @Nullable class_1297 entity, int i) throws CommandSyntaxException {
        PlaceholderContext context = null;
        if (src != null) {
            context = PlaceholderContext.of(src);
        } else {
            if (entity != null) {
                context = PlaceholderContext.of(entity);
            }
        }

        class_5250 component = parseMessage(MessageMod.SERVER_INSTANCE, context);
        class_5250 result = class_5250.method_43477(component.method_10851()).method_27696(component.method_10866());
        for (class_2561 sibling : component.method_10855()) {
            result.method_10852(class_2564.method_10881(src, sibling, entity, i + 1));
        }
        return result;
    }

    @Override
    public class_8823<?> method_54163() {
        return TYPE;
    }

    public String getKey() {
        return key;
    }

    public Map<String, class_2561> getPlaceholders() {
        return placeholders;
    }


    public class_5250 toText() {
        return class_5250.method_43477(this);
    }

    @Override
    public String toString() {
        return "message{key='" + this.key + "'" + ", placeholders=" + this.placeholders + "}";
    }

}
