package me.drex.message.mixin.network;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.drex.message.impl.MessageImpl;
import me.drex.message.impl.util.ComponentUtil;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9290;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

import static me.drex.message.impl.MessageMod.PACKET_LISTENER;

@Mixin(class_9290.class)
public abstract class ItemLoreMixin {

    @ModifyArg(
        method = "<clinit>",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/network/codec/StreamCodec;map(Ljava/util/function/Function;Ljava/util/function/Function;)Lnet/minecraft/network/codec/StreamCodec;"
        ), index = 1
    )
    private static Function<class_9290, List<class_2561>> parseLoreNewLines(Function<class_9290, List<class_2561>> from) {
        return itemLore -> {
            PlaceholderContext context;
            class_3222 target = PACKET_LISTENER.get();
            if (target != null) {
                context = PlaceholderContext.of(target);
                List<class_2561> result = new LinkedList<>();
                for (class_2561 line : itemLore.comp_2400()) {
                    if (line.method_10851() instanceof MessageImpl) {
                        // We need to parse lore manually, to apply our new line feature to the parsed components
                        ComponentUtil.parseNewLines(MessageImpl.parseComponent(line, context), result);
                    } else {
                        result.add(line);
                    }
                }
                return result.subList(0, Math.min(result.size(), class_9290.field_49343));
            }
            return itemLore.comp_2400();
        };
    }

}
