/*
 * Decompiled with CFR 0.152.
 */
package me.drex.message.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.DynamicTextNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.drex.message.impl.MessageMod;
import me.drex.message.impl.interfaces.ClientLanguageGetter;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageManager {
    public static final String DEFAULT_LANG = "en_us";
    public static final String MESSAGES = "messages";
    public static final ParserContext.Key<Function<String, class_2561>> PLACEHOLDERS = DynamicTextNode.key((String)"message_api/placeholders");
    public static final NodeParser PARSER = NodeParser.builder().simplifiedTextFormat().quickText().globalPlaceholders().placeholders(TagLikeParser.PLACEHOLDER_USER, PLACEHOLDERS).staticPreParsing().build();
    private static final Path CONFIG_MESSAGES_PATH = FabricLoader.getInstance().getConfigDir().resolve("messages");
    private static final String FILE_SUFFIX = ".json";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final Type LANGUAGEDATA_TYPE = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class}).getType();
    private static final Map<String, Map<String, String>> languageData = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, TextNode>> cachedLanguageData = new HashMap<String, Map<String, TextNode>>();

    private LanguageManager() {
    }

    public static void loadLanguages() {
        try {
            File langDir = CONFIG_MESSAGES_PATH.toFile();
            langDir.mkdirs();
            HashMap<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                LanguageManager.mergeLanguageData(data, LanguageManager.loadModLanguages(modContainer));
            }
            languageData.clear();
            languageData.putAll(data);
            cachedLanguageData.clear();
            cachedLanguageData.putAll(languageData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, innerEntry -> PARSER.parseNode((String)innerEntry.getValue()))))));
        }
        catch (Throwable throwable) {
            MessageMod.LOGGER.error("Failed to load message data, keeping previous data!", throwable);
        }
    }

    public static TextNode resolveMessageId(@Nullable class_3222 player, @NotNull String key) {
        TextNode message;
        String languageCode;
        Map<Object, Object> messages;
        if (player != null && (messages = cachedLanguageData.get(languageCode = ((ClientLanguageGetter)player.field_13987).getLanguage())) != null && (message = (TextNode)messages.get(key)) != null) {
            return message;
        }
        messages = cachedLanguageData.getOrDefault(DEFAULT_LANG, Collections.emptyMap());
        return messages.getOrDefault(key, PARSER.parseNode(key));
    }

    private static Map<String, Map<String, String>> loadModLanguages(ModContainer modContainer) {
        Optional optional = modContainer.findPath(MESSAGES);
        if (optional.isEmpty()) {
            return Collections.emptyMap();
        }
        String modId = modContainer.getMetadata().getId();
        Map<String, Map<String, String>> result = LanguageManager.loadModLanguagesFromPath((Path)optional.get());
        Path modMessageConfigPath = CONFIG_MESSAGES_PATH.resolve(modId);
        modMessageConfigPath.toFile().mkdir();
        LanguageManager.mergeLanguageData(result, LanguageManager.loadModLanguagesFromPath(modMessageConfigPath));
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            String json = GSON.toJson(entry.getValue(), LANGUAGEDATA_TYPE);
            Path languagePath = modMessageConfigPath.resolve(entry.getKey() + FILE_SUFFIX);
            try {
                Files.writeString(languagePath, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                MessageMod.LOGGER.error("Failed to save language file \"{}\"", (Object)languagePath, (Object)e);
            }
        }
        return result;
    }

    private static Map<String, Map<String, String>> loadModLanguagesFromPath(Path root) {
        HashMap<String, Map<String, String>> hashMap;
        block11: {
            HashMap<String, Map<String, String>> messages = new HashMap<String, Map<String, String>>();
            Stream<Path> files = Files.walk(root, 1, new FileVisitOption[0]);
            try {
                Set paths = files.filter(p -> !Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toSet());
                for (Path path : paths) {
                    try {
                        String languageCode = LanguageManager.parseLanguageCode(path.getFileName().toString());
                        messages.put(languageCode, LanguageManager.loadLanguageData(path));
                    }
                    catch (IllegalArgumentException e) {
                        MessageMod.LOGGER.error("Failed to parse language file name", (Throwable)e);
                    }
                }
                hashMap = messages;
                if (files == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    MessageMod.LOGGER.error("Failed to load language files", (Throwable)e);
                    return Collections.emptyMap();
                }
            }
            files.close();
        }
        return hashMap;
    }

    private static void mergeLanguageData(Map<String, Map<String, String>> original, Map<String, Map<String, String>> otherMap) {
        for (Map.Entry<String, Map<String, String>> entry : otherMap.entrySet()) {
            Map mergedMap = original.getOrDefault(entry.getKey(), new HashMap());
            mergedMap.putAll(entry.getValue());
            original.put(entry.getKey(), mergedMap);
        }
    }

    private static String parseLanguageCode(String fileName) {
        if (!fileName.endsWith(FILE_SUFFIX)) {
            throw new IllegalArgumentException("Language files have to end with \".json\", but found \"" + fileName + "\"");
        }
        String languageCode = fileName.substring(0, fileName.length() - FILE_SUFFIX.length());
        if (languageCode.length() > 16) {
            throw new IllegalArgumentException("Language code must not be longer than 16 characters: \"" + languageCode + "\"");
        }
        return languageCode;
    }

    private static Map<String, String> loadLanguageData(Path path) {
        try {
            String data = Files.readString(path);
            return (Map)GSON.fromJson(data, LANGUAGEDATA_TYPE);
        }
        catch (IOException e) {
            MessageMod.LOGGER.error("Failed to read data from \"" + String.valueOf(path) + "\"", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

