package me.drex.message.impl;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.drex.message.api.LocalizedMessageBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

public class LocalizedMessageBuilderImpl implements LocalizedMessageBuilder {

    private final String key;
    private final Map<String, class_2561> placeholders = new HashMap<>();
    @Nullable
    private PlaceholderContext staticContext = null;

    public LocalizedMessageBuilderImpl(String key) {
        this.key = key;
    }

    @Override
    public LocalizedMessageBuilder addPlaceholder(String key, boolean bool) {
        this.placeholders.put(key, class_2561.method_43470(String.valueOf(bool)));
        return this;
    }

    @Override
    public LocalizedMessageBuilder addPlaceholder(String key, Number number) {
        this.placeholders.put(key, class_2561.method_43470(String.valueOf(number)));
        return this;
    }

    @Override
    public LocalizedMessageBuilder addPlaceholder(String key, String string) {
        this.placeholders.put(key, class_2561.method_43470(string));
        return this;
    }

    @Override
    public LocalizedMessageBuilder addPlaceholder(String key, class_2561 component) {
        this.placeholders.put(key, component);
        return this;
    }

    @Override
    public LocalizedMessageBuilder addPlaceholders(Map<String, class_2561> placeholders) {
        this.placeholders.putAll(placeholders);
        return this;
    }

    @Override
    public LocalizedMessageBuilder setStaticContext(@Nullable PlaceholderContext staticContext) {
        this.staticContext = staticContext;
        return this;
    }

    @Override
    public class_5250 build() {
        return new MessageImpl(key, placeholders, staticContext).toText();

    }
}
