package me.drex.message.mixin.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import me.drex.message.impl.MessageMod;
import me.drex.message.impl.interfaces.ConnectionHolder;
import net.minecraft.class_2535;
import net.minecraft.class_2545;
import net.minecraft.class_2596;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2545.class)
public abstract class PacketEncoderMixin implements ConnectionHolder {

    @Unique
    private class_2535 message_api$connection;

    @Inject(
        method = "encode(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/protocol/Packet;Lio/netty/buffer/ByteBuf;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/network/codec/StreamCodec;encode(Ljava/lang/Object;Ljava/lang/Object;)V",
            shift = At.Shift.BEFORE
        )
    )
    private void setPacketListener(ChannelHandlerContext channelHandlerContext, class_2596<?> packet, ByteBuf byteBuf, CallbackInfo ci) {
        if (message_api$connection != null && message_api$connection.method_10744() instanceof class_3244 listener) {
            MessageMod.PACKET_LISTENER.set(listener.method_32311());
        }
    }

    @Inject(
        method = "encode(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/protocol/Packet;Lio/netty/buffer/ByteBuf;)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/network/codec/StreamCodec;encode(Ljava/lang/Object;Ljava/lang/Object;)V",
            shift = At.Shift.AFTER
        )
    )
    private void clearPacketListener(ChannelHandlerContext channelHandlerContext, class_2596<?> packet, ByteBuf byteBuf, CallbackInfo ci) {
        MessageMod.PACKET_LISTENER.remove();
    }

    @Override
    public void message_api$setConnection(class_2535 connection) {
        this.message_api$connection = connection;
    }
}
