package me.drex.message.api;

import eu.pb4.placeholders.api.PlaceholderContext;
import me.drex.message.impl.LocalizedMessageBuilderImpl;
import me.drex.message.impl.MessageImpl;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public interface LocalizedMessage {

    static LocalizedMessageBuilder builder(String key) {
        return new LocalizedMessageBuilderImpl(key);
    }

    static class_5250 localized(String key) {
        return localized(key, Map.of());
    }

    static class_5250 localized(String key, Map<String, class_2561> placeholders) {
        return localized(key, placeholders, null);
    }

    static class_5250 localized(String key, @Nullable PlaceholderContext staticContext) {
        return localized(key, Map.of(), staticContext);
    }

    static class_5250 localized(String key, Map<String, class_2561> placeholders, @Nullable PlaceholderContext staticContext) {
        return new MessageImpl(key, placeholders, staticContext).toText();
    }
}
