/*
 * Decompiled with CFR 0.152.
 */
package me.cioco.inventorycleaner.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.stream.Collectors;
import me.cioco.inventorycleaner.config.InventoryCleaner;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class InventoryCleanerCommand {
    private static final class_310 mc = class_310.method_1551();
    private static InventoryCleaner inventoryCleaner;

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, InventoryCleaner cleaner) {
        inventoryCleaner = cleaner;
        LiteralArgumentBuilder root = ClientCommandManager.literal((String)"ic");
        root.then(ClientCommandManager.literal((String)"additem").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2232.method_9441()).executes(InventoryCleanerCommand::addItem)));
        root.then(ClientCommandManager.literal((String)"delitem").then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2232.method_9441()).executes(InventoryCleanerCommand::removeItem)));
        root.then(ClientCommandManager.literal((String)"lockslot").then(ClientCommandManager.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(InventoryCleanerCommand::lockSlot)));
        root.then(ClientCommandManager.literal((String)"unlockslot").then(ClientCommandManager.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(InventoryCleanerCommand::unlockSlot)));
        root.then(ClientCommandManager.literal((String)"list").executes(InventoryCleanerCommand::listItems));
        root.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").then(ClientCommandManager.literal((String)"save").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(InventoryCleanerCommand::saveConfig)))).then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(InventoryCleanerCommand::loadConfig))));
        dispatcher.register(root);
    }

    private static int addItem(CommandContext<FabricClientCommandSource> context) {
        class_746 player = InventoryCleanerCommand.mc.field_1724;
        class_2960 itemId = (class_2960)context.getArgument("item", class_2960.class);
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
        if (item == null) {
            player.method_7353(class_2561.method_30163((String)("\u00a7cInvalid item ID: " + String.valueOf(itemId))), false);
            return 0;
        }
        if (inventoryCleaner.isItemInThrowList(item)) {
            player.method_7353(class_2561.method_30163((String)("\u00a7eAlready added: " + String.valueOf(itemId))), false);
        } else {
            inventoryCleaner.addItemToThrow(item);
            inventoryCleaner.saveConfiguration();
            player.method_7353(class_2561.method_30163((String)("\u00a7aAdded: " + String.valueOf(itemId))), false);
        }
        return 1;
    }

    private static int removeItem(CommandContext<FabricClientCommandSource> context) {
        class_746 player = InventoryCleanerCommand.mc.field_1724;
        class_2960 itemId = (class_2960)context.getArgument("item", class_2960.class);
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
        if (item == null) {
            player.method_7353(class_2561.method_30163((String)("\u00a7cInvalid item ID: " + String.valueOf(itemId))), false);
            return 0;
        }
        if (inventoryCleaner.isItemInThrowList(item)) {
            inventoryCleaner.removeItemToThrow(item);
            inventoryCleaner.saveConfiguration();
            player.method_7353(class_2561.method_30163((String)("\u00a7aRemoved: " + String.valueOf(itemId))), false);
        } else {
            player.method_7353(class_2561.method_30163((String)("\u00a7eItem not found: " + String.valueOf(itemId))), false);
        }
        return 1;
    }

    private static int lockSlot(CommandContext<FabricClientCommandSource> context) {
        int slotId = (Integer)context.getArgument("slot", Integer.class);
        inventoryCleaner.lockSlot(slotId);
        InventoryCleanerCommand.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a76Slot " + slotId + " locked.")), false);
        inventoryCleaner.saveConfiguration();
        return 1;
    }

    private static int unlockSlot(CommandContext<FabricClientCommandSource> context) {
        int slotId = (Integer)context.getArgument("slot", Integer.class);
        inventoryCleaner.unlockSlot(slotId);
        InventoryCleanerCommand.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7eSlot " + slotId + " unlocked.")), false);
        inventoryCleaner.saveConfiguration();
        return 1;
    }

    private static int listItems(CommandContext<FabricClientCommandSource> context) {
        class_746 player = InventoryCleanerCommand.mc.field_1724;
        Set<class_1792> items = inventoryCleaner.getItemsToThrow();
        Set<Integer> locked = inventoryCleaner.getLockedSlots();
        if (items.isEmpty() && locked.isEmpty()) {
            player.method_7353(class_2561.method_30163((String)"\u00a77No items or locked slots configured."), false);
            return 1;
        }
        if (!items.isEmpty()) {
            String itemList = items.stream().map(i -> class_7923.field_41178.method_10221(i).toString()).collect(Collectors.joining(", "));
            player.method_7353(class_2561.method_30163((String)("\u00a7aThrow List: \u00a7f" + itemList)), false);
        }
        if (!locked.isEmpty()) {
            String lockedList = locked.stream().map(String::valueOf).collect(Collectors.joining(", "));
            player.method_7353(class_2561.method_30163((String)("\u00a76Locked Slots: \u00a7f" + lockedList)), false);
        }
        return 1;
    }

    private static int saveConfig(CommandContext<FabricClientCommandSource> context) {
        String name = (String)context.getArgument("name", String.class);
        inventoryCleaner.saveConfiguration(name);
        InventoryCleanerCommand.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7aSaved configuration as '" + name + "'.")), false);
        return 1;
    }

    private static int loadConfig(CommandContext<FabricClientCommandSource> context) {
        String name = (String)context.getArgument("name", String.class);
        boolean success = inventoryCleaner.loadConfiguration(name);
        if (success) {
            InventoryCleanerCommand.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7aLoaded configuration '" + name + "'.")), false);
        } else {
            InventoryCleanerCommand.mc.field_1724.method_7353(class_2561.method_30163((String)("\u00a7cCould not find configuration '" + name + "'.")), false);
        }
        return 1;
    }
}

