/*
 * Decompiled with CFR 0.152.
 */
package me.cioco.inventorycleaner.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public class InventoryCleaner
implements ClientModInitializer {
    private static final String DEFAULT_CONFIG_NAME = "default";
    private boolean isEnabled = true;
    private final Set<class_1792> itemsToThrow = new HashSet<class_1792>();
    private final Set<Integer> lockedSlots = new HashSet<Integer>();
    private int tickCounter = 0;

    public void onInitializeClient() {
        this.loadConfiguration(DEFAULT_CONFIG_NAME);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.isEnabled && client.field_1724 != null) {
                this.cleanInventory(client);
            }
        });
    }

    public Set<class_1792> getItemsToThrow() {
        return this.itemsToThrow;
    }

    public Set<Integer> getLockedSlots() {
        return this.lockedSlots;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void addItemToThrow(class_1792 item) {
        this.itemsToThrow.add(item);
    }

    public void removeItemToThrow(class_1792 item) {
        this.itemsToThrow.remove(item);
    }

    public boolean isItemInThrowList(class_1792 item) {
        return this.itemsToThrow.contains(item);
    }

    public void lockSlot(int slotId) {
        this.lockedSlots.add(slotId);
    }

    public void unlockSlot(int slotId) {
        this.lockedSlots.remove(slotId);
    }

    public boolean isSlotLocked(int slotId) {
        return this.lockedSlots.contains(slotId);
    }

    public void saveConfiguration() {
        this.saveConfiguration(DEFAULT_CONFIG_NAME);
    }

    public void saveConfiguration(String name) {
        try {
            Path configDir = this.getConfigDir();
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path configPath = configDir.resolve(name + ".properties");
            Properties properties = new Properties();
            for (class_1792 item : this.itemsToThrow) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
                properties.setProperty(itemId.toString(), "true");
            }
            for (Integer slotId : this.lockedSlots) {
                properties.setProperty("lock_" + slotId, "true");
            }
            try (OutputStream output = Files.newOutputStream(configPath, new OpenOption[0]);){
                properties.store(output, "InventoryCleaner configuration: " + name);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean loadConfiguration(String name) {
        boolean bl;
        block13: {
            Path configPath = this.getConfigDir().resolve(name + ".properties");
            if (!Files.exists(configPath, new LinkOption[0])) {
                return false;
            }
            this.itemsToThrow.clear();
            this.lockedSlots.clear();
            InputStream input = Files.newInputStream(configPath, new OpenOption[0]);
            try {
                Properties properties = new Properties();
                properties.load(input);
                for (String key : properties.stringPropertyNames()) {
                    if (key.startsWith("lock_")) {
                        try {
                            int slot = Integer.parseInt(key.substring(5));
                            this.lockedSlots.add(slot);
                        }
                        catch (NumberFormatException slot) {}
                        continue;
                    }
                    class_2960 itemId = class_2960.method_60654((String)key);
                    if (!class_7923.field_41178.method_10250(itemId)) continue;
                    this.itemsToThrow.add((class_1792)class_7923.field_41178.method_63535(itemId));
                }
                bl = true;
                if (input == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            input.close();
        }
        return bl;
    }

    private Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir().resolve("inventory-cleaner");
    }

    private void cleanInventory(class_310 client) {
        if (++this.tickCounter % 10 != 0) {
            return;
        }
        class_1723 screenHandler = client.field_1724.field_7498;
        for (class_1735 slot : screenHandler.field_7761) {
            class_1799 itemStack;
            if (slot.field_7874 < 9 || slot.field_7874 > 44 || this.isSlotLocked(slot.field_7874) || (itemStack = slot.method_7677()).method_7960() || !this.itemsToThrow.contains(itemStack.method_7909())) continue;
            client.field_1761.method_2906(screenHandler.field_7763, slot.field_7874, 1, class_1713.field_7795, (class_1657)client.field_1724);
        }
    }
}

