/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.projectend.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.projectend.client.model.ModelEndersent;
import net.mcreator.projectend.client.model.animations.EndersentAnimation;
import net.mcreator.projectend.entity.EndersentEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EndersentRenderer
extends MobRenderer<EndersentEntity, ModelEndersent<EndersentEntity>> {
    public EndersentRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelEndersent.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<EndersentEntity, ModelEndersent<EndersentEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"project_end:textures/entities/endersentglow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, EndersentEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ModelEndersent model = new ModelEndersent(Minecraft.getInstance().getEntityModels().bakeLayer(ModelEndersent.LAYER_LOCATION));
                ((ModelEndersent)this.getParentModel()).copyPropertiesTo(model);
                model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    public ResourceLocation getTextureLocation(EndersentEntity entity) {
        return ResourceLocation.parse((String)"project_end:textures/entities/endersenttexture.png");
    }

    private static final class AnimatedModel
    extends ModelEndersent<EndersentEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<EndersentEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(EndersentEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(EndersentAnimation.Walk, limbSwing, limbSwingAmount, 1.5f, 1.0f);
                this.animate(entity.animationState1, EndersentAnimation.Smash, ageInTicks, 1.5f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(EndersentEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

