/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.projectend.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.projectend.client.model.Modelwatchling;
import net.mcreator.projectend.client.model.animations.watchlingAnimation;
import net.mcreator.projectend.entity.WatchlingEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WatchlingRenderer
extends MobRenderer<WatchlingEntity, Modelwatchling<WatchlingEntity>> {
    public WatchlingRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelwatchling.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<WatchlingEntity, Modelwatchling<WatchlingEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"project_end:textures/entities/watchlingglow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, WatchlingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                Modelwatchling model = new Modelwatchling(Minecraft.getInstance().getEntityModels().bakeLayer(Modelwatchling.LAYER_LOCATION));
                ((Modelwatchling)this.getParentModel()).copyPropertiesTo(model);
                model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
    }

    public ResourceLocation getTextureLocation(WatchlingEntity entity) {
        return ResourceLocation.parse((String)"project_end:textures/entities/watchlingtexture.png");
    }

    private static final class AnimatedModel
    extends Modelwatchling<WatchlingEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<WatchlingEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(WatchlingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(watchlingAnimation.walk, limbSwing, limbSwingAmount, 1.5f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(WatchlingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

