/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.projectend.init;

import net.mcreator.projectend.entity.EndersentEntity;
import net.mcreator.projectend.entity.SnarelingEntity;
import net.mcreator.projectend.entity.SnarelingGooEntity;
import net.mcreator.projectend.entity.WatchlingEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ProjectEndModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"project_end");
    public static final DeferredHolder<EntityType<?>, EntityType<SnarelingEntity>> SNARELING = ProjectEndModEntities.register("snareling", EntityType.Builder.of(SnarelingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<SnarelingGooEntity>> SNARELING_GOO = ProjectEndModEntities.register("snareling_goo", EntityType.Builder.of(SnarelingGooEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<WatchlingEntity>> WATCHLING = ProjectEndModEntities.register("watchling", EntityType.Builder.of(WatchlingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<EndersentEntity>> ENDERSENT = ProjectEndModEntities.register("endersent", EntityType.Builder.of(EndersentEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 3.3f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SnarelingEntity.init(event);
        WatchlingEntity.init(event);
        EndersentEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SNARELING.get(), SnarelingEntity.createAttributes().build());
        event.put((EntityType)WATCHLING.get(), WatchlingEntity.createAttributes().build());
        event.put((EntityType)ENDERSENT.get(), EndersentEntity.createAttributes().build());
    }
}

