/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.projectend.client;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RenderUtils {
    public static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    public static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png");
    private static final Minecraft mc = Minecraft.getInstance();

    public static void swapVanillaTexture(ResourceLocation original, ResourceLocation replacement) {
        TextureManager textureManager = mc.getTextureManager();
        textureManager.registerAndLoad(original, (ReloadableTexture)new SimpleTexture(replacement));
    }

    public static void renderCustomSun(RenderLevelStageEvent.AfterSky event, ResourceLocation texture) {
        PoseStack posestack = event.getPoseStack();
        posestack.pushPose();
        GlStateManager._enableBlend();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._blendFuncSeparate((int)770, (int)1, (int)770, (int)1);
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float f11 = 1.0f - RenderUtils.mc.getInstance().player.level().getRainLevel(partialTick);
        posestack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        posestack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(RenderUtils.mc.getInstance().player.level().getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f1 = posestack.last().pose();
        float f12 = 30.0f;
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.celestial((ResourceLocation)texture));
        vertexConsumer.addVertex(matrix4f1, -f12, 100.0f, -f12).setUv(0.0f, 0.0f).setColor(-1);
        vertexConsumer.addVertex(matrix4f1, f12, 100.0f, -f12).setUv(1.0f, 0.0f).setColor(-1);
        vertexConsumer.addVertex(matrix4f1, f12, 100.0f, f12).setUv(1.0f, 1.0f).setColor(-1);
        vertexConsumer.addVertex(matrix4f1, -f12, 100.0f, f12).setUv(0.0f, 1.0f).setColor(-1);
        bufferSource.endBatch();
        GlStateManager._disableBlend();
        GlStateManager._depthMask((boolean)true);
        posestack.popPose();
    }

    public static void renderCustomMoon(RenderLevelStageEvent.AfterSky event, ResourceLocation texture) {
        PoseStack posestack = event.getPoseStack();
        posestack.pushPose();
        GlStateManager._enableBlend();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._blendFuncSeparate((int)770, (int)1, (int)770, (int)1);
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float f11 = 1.0f - RenderUtils.mc.getInstance().player.level().getRainLevel(partialTick);
        posestack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        posestack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(RenderUtils.mc.getInstance().player.level().getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f1 = posestack.last().pose();
        float f12 = 20.0f;
        int k = RenderUtils.mc.getInstance().player.level().getMoonPhase();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.celestial((ResourceLocation)texture));
        vertexConsumer.addVertex(matrix4f1, -f12, -100.0f, f12).setUv(f15, f16).setColor(-1);
        vertexConsumer.addVertex(matrix4f1, f12, -100.0f, f12).setUv(f13, f16).setColor(-1);
        vertexConsumer.addVertex(matrix4f1, f12, -100.0f, -f12).setUv(f13, f14).setColor(-1);
        vertexConsumer.addVertex(matrix4f1, -f12, -100.0f, -f12).setUv(f15, f14).setColor(-1);
        bufferSource.endBatch();
        GlStateManager._disableBlend();
        GlStateManager._depthMask((boolean)true);
        posestack.popPose();
    }

    public static void renderCustomSkybox(RenderLevelStageEvent.AfterSky event, ResourceLocation texture, int color, float alpha) {
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        GlStateManager._enableBlend();
        GlStateManager.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GlStateManager._depthMask((boolean)false);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.celestial((ResourceLocation)texture));
        float distance = 100.0f;
        float size = 100.0f;
        int colorWithAlpha = color & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        RenderUtils.renderSkyboxQuad(poseStack, vertexConsumer, colorWithAlpha, -size, distance, -size, 0.25f, 0.33333334f, size, distance, -size, 0.5f, 0.33333334f, size, distance, size, 0.5f, 0.0f, -size, distance, size, 0.25f, 0.0f);
        RenderUtils.renderSkyboxQuad(poseStack, vertexConsumer, colorWithAlpha, -size, -distance, -size, 0.25f, 0.6666667f, -size, -distance, size, 0.25f, 1.0f, size, -distance, size, 0.5f, 1.0f, size, -distance, -size, 0.5f, 0.6666667f);
        RenderUtils.renderSkyboxQuad(poseStack, vertexConsumer, colorWithAlpha, -distance, -size, size, 0.0f, 0.6666667f, -distance, -size, -size, 0.25f, 0.6666667f, -distance, size, -size, 0.25f, 0.33333334f, -distance, size, size, 0.0f, 0.33333334f);
        RenderUtils.renderSkyboxQuad(poseStack, vertexConsumer, colorWithAlpha, -size, -size, -distance, 0.25f, 0.6666667f, size, -size, -distance, 0.5f, 0.6666667f, size, size, -distance, 0.5f, 0.33333334f, -size, size, -distance, 0.25f, 0.33333334f);
        RenderUtils.renderSkyboxQuad(poseStack, vertexConsumer, colorWithAlpha, distance, -size, -size, 0.5f, 0.6666667f, distance, -size, size, 0.75f, 0.6666667f, distance, size, size, 0.75f, 0.33333334f, distance, size, -size, 0.5f, 0.33333334f);
        RenderUtils.renderSkyboxQuad(poseStack, vertexConsumer, colorWithAlpha, size, -size, distance, 0.75f, 0.6666667f, -size, -size, distance, 1.0f, 0.6666667f, -size, size, distance, 1.0f, 0.33333334f, size, size, distance, 0.75f, 0.33333334f);
        bufferSource.endBatch();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._disableBlend();
        poseStack.popPose();
    }

    private static void renderSkyboxQuad(PoseStack poseStack, VertexConsumer vertexConsumer, int color, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float x4, float y4, float z4, float u4, float v4) {
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix = pose.pose();
        vertexConsumer.addVertex(matrix, x1, y1, z1).setColor(color).setUv(u1, v1);
        vertexConsumer.addVertex(matrix, x2, y2, z2).setColor(color).setUv(u2, v2);
        vertexConsumer.addVertex(matrix, x3, y3, z3).setColor(color).setUv(u3, v3);
        vertexConsumer.addVertex(matrix, x4, y4, z4).setColor(color).setUv(u4, v4);
    }

    public static int[] getRGB(int hexColor) {
        int[] rgb = new int[]{hexColor >> 16 & 0xFF, hexColor >> 8 & 0xFF, hexColor & 0xFF};
        return rgb;
    }
}

