package me.pog5.leashmod;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeashPlayers implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("leashmod");

    private static class_1928.class_4313<class_1928.class_4310> ruleEnabled;
    private static class_1928.class_4313<DoubleRule> ruleDistanceMin;
    private static class_1928.class_4313<DoubleRule> ruleDistanceMax;
    private static class_1928.class_4313<class_1928.class_4310> ruleAllowLeashedRemoveFenceKnot;

    public static LeashSettings getSettings(class_3218 world) {
        return new LeashSettings() {
            private class_1928 getGameRules() {
                return world.method_64395();
            }

            @Override
            public boolean isEnabled() {
                return getGameRules().method_8355(ruleEnabled);
            }

            @Override
            public double getDistanceMin() {
                return getGameRules().method_20746(ruleDistanceMin).get();
            }

            @Override
            public double getDistanceMax() {
                return getGameRules().method_20746(ruleDistanceMax).get();
            }

            @Override
            public boolean allowLeashedRemoveFenceKnot() {
                return getGameRules().method_20746(ruleAllowLeashedRemoveFenceKnot).method_20753();
            }
        };
    }

    @Override
    public void onInitialize() {
        ruleEnabled = GameRuleRegistry.register("leashPlayersEnabled", class_1928.class_5198.field_24094, GameRuleFactory.createBooleanRule(true));
        ruleDistanceMin = GameRuleRegistry.register("leashPlayersDistanceMin", class_1928.class_5198.field_24094, GameRuleFactory.createDoubleRule(4.0D));
        ruleDistanceMax = GameRuleRegistry.register("leashPlayersDistanceMax", class_1928.class_5198.field_24094, GameRuleFactory.createDoubleRule(10.0D));
        ruleAllowLeashedRemoveFenceKnot = GameRuleRegistry.register("leashPlayersAllowLeashedRemoveFenceKnot", class_1928.class_5198.field_24094, GameRuleFactory.createBooleanRule(false));
        LOGGER.info("Initialized LeashPlayers");
    }
}
