package me.pog5.leashmod.mixin;

import me.pog5.leashmod.LeashImpl;
import me.pog5.leashmod.LeashPlayers;
import me.pog5.leashmod.LeashProxyEntity;
import me.pog5.leashmod.LeashSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class MixinServerPlayerEntity implements LeashImpl {
    @Unique
    private class_3222 getSelf() {
        return (class_3222)(Object)this;
    }

    @Shadow
    public abstract boolean isDisconnected();

    @Shadow
    public abstract class_3218 getEntityWorld();

    @Unique
    private final LeashSettings leashplayers$settings = LeashPlayers.getSettings(this.getEntityWorld());

    @Unique
    private LeashProxyEntity leashplayers$proxy;
    @Unique
    private class_1297 leashplayers$holder;
    public class_1297 leashplayers$getHolder() {
        return this.leashplayers$holder;
    }
    public boolean leashplayers$shouldCancel() {
        return leashplayers$getHolder() != null && !leashplayers$settings.allowLeashedRemoveFenceKnot();
    }

    @Unique
    private int leashplayers$lastage;

    @Unique
    private boolean leashplayers$disabled() {
        return !leashplayers$settings.isEnabled();
    }

    @Unique
    private void leashplayers$update() {
        if (
            leashplayers$holder != null && (
                leashplayers$disabled()
                || !leashplayers$holder.method_5805()
                || isDisconnected()
                || getSelf().method_5765()
            )
        ) {
            leashplayers$detach();
            leashplayers$drop();
        }

        if (leashplayers$proxy != null) {
            if (leashplayers$proxy.proxyIsRemoved()) {
                leashplayers$proxy = null;
            }
            else {
                class_1297 holderActual = leashplayers$holder;
                class_1297 holderTarget = leashplayers$proxy.method_60952();

                if (holderTarget == null && holderActual != null) {
                    leashplayers$detach();
                    leashplayers$drop();
                }
                else if (holderTarget != holderActual) {
                    leashplayers$attach(holderTarget);
                }
            }
        }

        leashplayers$apply();
    }

    @Unique
    private void leashplayers$apply() {
        class_3222 player = getSelf();
        class_1297 holder = leashplayers$holder;
        if (holder == null) return;
        if (holder.method_73183() != player.method_51469()) return;

        float distance = player.method_5739(holder);
        if (distance < leashplayers$settings.getDistanceMin()) {
            return;
        }
        if (distance > leashplayers$settings.getDistanceMax()) {
            leashplayers$detach();
            leashplayers$drop();
            return;
        }

        double dx = (holder.method_23317() - player.method_23317()) / (double) distance;
        double dy = (holder.method_23318() - player.method_23318()) / (double) distance;
        double dz = (holder.method_23321() - player.method_23321()) / (double) distance;

        player.method_5762(
            Math.copySign(dx * dx * 0.4D, dx),
            Math.copySign(dy * dy * 0.4D, dy),
            Math.copySign(dz * dz * 0.4D, dz)
        );

        player.field_13987.method_14364(new class_2743(player));
        player.field_6007 = false;
    }

    @Unique
    private void leashplayers$attach(class_1297 holder) {
        LeashPlayers.LOGGER.info("LeashPlayers$attach");

        leashplayers$holder = holder;
        class_1309 leashed = getSelf();

        if (leashplayers$proxy == null) {
            leashplayers$proxy = new LeashProxyEntity(leashed);
            leashed.method_73183().method_8649(leashplayers$proxy);
            leashplayers$proxy.method_5808(leashed.method_23317(), leashed.method_23318(), leashed.method_23321(), 0.0F, 0.0F);
            final class_243 pos = new class_243(leashed.method_23317(), leashed.method_23318(), leashed.method_23321());
            leashplayers$proxy.method_5648(!leashplayers$proxy.method_5767());
            leashplayers$proxy.method_29495(pos);
            leashplayers$proxy.method_5648(!leashplayers$proxy.method_5767());
        }
        leashplayers$proxy.method_60964(leashplayers$holder, true);
        leashplayers$lastage = leashed.field_6012;
    }

    @Unique
    private void leashplayers$detach() {
        LeashPlayers.LOGGER.info("LeashPlayers$detach");
        leashplayers$holder = null;

        if (leashplayers$proxy != null) {
            if (leashplayers$proxy.method_5805() || !leashplayers$proxy.proxyIsRemoved()) {
                leashplayers$proxy.proxyRemove();
            }
            leashplayers$proxy = null;
        }
    }

    @Unique
    private void leashplayers$drop() {
        getSelf().method_5706(getEntityWorld(), class_1802.field_8719);
    }

    @Inject(method = "tick()V", at = @At("TAIL"))
    private void leashplayers$tick(CallbackInfo info) {
        leashplayers$update();
    }

    @Override
    public class_1269 leashplayers$interact(class_1657 player, class_1268 hand) {
        if (leashplayers$disabled()) return class_1269.field_5811;

        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == class_1802.field_8719 && leashplayers$holder == null) {
            if (!player.method_68878()) {
                stack.method_7934(1);
            }
            leashplayers$attach(player);
            return class_1269.field_5812;
        }

        if (leashplayers$holder == player && leashplayers$lastage + 20 < getSelf().field_6012) {
            if (!player.method_68878()) {
                leashplayers$drop();
            }
            leashplayers$detach();
            return class_1269.field_5812;
        }

        return class_1269.field_5811;
    }

    @Inject(method = "onDisconnect", at = @At("RETURN"))
    private void leashplayers$disconnect(CallbackInfo ci) {
        if (leashplayers$holder != null) {
            leashplayers$detach();
            leashplayers$drop();
        }
    }

    @Inject(method = "onDeath", at = @At("RETURN"))
    private void leashplayers$onDeath(CallbackInfo ci) {
        if (leashplayers$holder != null) {
            leashplayers$detach();
            leashplayers$drop();
        }
    }
}
