/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import xshyo.us.theglow.D.B;
import xshyo.us.theglow.D.C;
import xshyo.us.theglow.D.D;
import xshyo.us.theglow.F.A;
import xshyo.us.theglow.libs.bstats.bukkit.Metrics;
import xshyo.us.theglow.libs.config.YamlDocument;
import xshyo.us.theglow.libs.config.dvs.versioning.BasicVersioning;
import xshyo.us.theglow.libs.config.settings.dumper.DumperSettings;
import xshyo.us.theglow.libs.config.settings.general.GeneralSettings;
import xshyo.us.theglow.libs.config.settings.loader.LoaderSettings;
import xshyo.us.theglow.libs.config.settings.updater.UpdaterSettings;
import xshyo.us.theglow.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import xshyo.us.theglow.libs.theAPI.commands.AbstractCommand;
import xshyo.us.theglow.libs.theAPI.commands.CommandArg;
import xshyo.us.theglow.libs.theAPI.commands.DynamicCommand;
import xshyo.us.theglow.libs.theAPI.utilities.Utils;

public final class TheGlow
extends xshyo.us.theglow.A
implements Listener {
    private BukkitAudiences adventure;
    private static TheGlow instance;
    private YamlDocument lang;
    private YamlDocument conf;
    private YamlDocument menus;
    private final List<CommandArg> commandArgs;
    private final ListeningExecutorService executor;
    private xshyo.us.theglow.I.A database;
    private xshyo.us.theglow.E.C glowManager;
    private xshyo.us.theglow.E.A glowLoad;
    private boolean updateAvailable;
    private String newUpdateVersion;
    private String UpdateDescription;
    private xshyo.us.theglow.J.A pluginIntegrationManager;
    private final List<String> fixedRegisteredCommands = new ArrayList<String>();
    private static final DecimalFormat NUMBER_FORMAT_NANO;

    public TheGlow() {
        instance = this;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.commandArgs = new ArrayList<CommandArg>();
    }

    @Override
    public void load() {
    }

    @Override
    public void start() {
        long l = System.nanoTime();
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        this.pluginIntegrationManager = new xshyo.us.theglow.J.A();
        AbstractCommand.enable();
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        this.Hooks();
        this.setupMetrics();
        String string = this.getConf().getString("config.storage-method");
        this.database = string.equalsIgnoreCase("mysql") ? new xshyo.us.theglow.H.B() : new xshyo.us.theglow.H.A();
        this.database.B();
        this.glowManager = new xshyo.us.theglow.E.C();
        this.glowLoad = new xshyo.us.theglow.E.A();
        this.glowLoad.B();
        String string3 = Bukkit.getVersion();
        this.adventure = string3.contains("1.16.5") ? null : BukkitAudiences.create((Plugin)this);
        if (this.getConf().getBoolean("config.update-checker").booleanValue()) {
            C c = new C(this);
            c.getReleaseInfo("name", string2 -> {
                String string3 = this.getDescription().getVersion();
                this.newUpdateVersion = string2;
                if (!string3.equals(this.newUpdateVersion) && !this.getDescription().getVersion().contains("DEV")) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&f[TheGlow] An update for &aTheGlow (" + this.newUpdateVersion + ") &fis available at:")));
                    Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f[TheGlow] &7https://discord.com/invite/s3Qu3Taz2y"));
                    this.updateAvailable = true;
                    c.getReleaseInfo("body", string -> {
                        this.UpdateDescription = string;
                    });
                }
            });
        }
        this.logPluginEnabled(l);
    }

    @Override
    public void setupListener() {
        Plugin plugin;
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new D(), (Plugin)this);
        pluginManager.registerEvents((Listener)new C(this), (Plugin)this);
        Plugin plugin2 = pluginManager.getPlugin("LibsDisguises");
        if (plugin2 != null && plugin2.isEnabled()) {
            pluginManager.registerEvents((Listener)new B(), (Plugin)this);
        }
        if ((plugin = pluginManager.getPlugin("GSit")) != null && plugin.isEnabled()) {
            pluginManager.registerEvents((Listener)new xshyo.us.theglow.D.A(), (Plugin)this);
        }
    }

    @Override
    public void setupFiles() {
        this.getLogger().log(Level.INFO, "Registering files...");
        try {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("config.glow.auto-glow-on-join.groups");
            this.conf = YamlDocument.create(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().addIgnoredRoutes("3", hashSet, '.').setKeepAll(true).setVersioning(new BasicVersioning("file-version")).build());
            this.lang = YamlDocument.create(new File(this.getDataFolder(), "messages.yml"), this.getResource("messages.yml"), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("file-version")).build());
            HashSet<String> hashSet2 = new HashSet<String>();
            hashSet2.add("inventories.glowing.glows.colors");
            hashSet2.add("inventories.glowing.custom-items");
            this.menus = YamlDocument.create(new File(this.getDataFolder(), "menus.yml"), this.getResource("menus.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().addIgnoredRoutes("2", hashSet2, '.').setKeepAll(true).setVersioning(new BasicVersioning("file-version")).build());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setupActions() {
        this.getLogger().log(Level.INFO, "Registering Actions...");
        this.getActionExecutor().getActionHandlers().put("[minimessage]", new xshyo.us.theglow.F.B());
        this.getActionExecutor().getActionHandlers().put("[minibroadcast]", new A());
    }

    private void logPluginEnabled(long l) {
        Bukkit.getConsoleSender().sendMessage(Utils.translate("&2[TheGlow] Server version: " + Bukkit.getServer().getVersion() + " " + Bukkit.getServer().getBukkitVersion()));
        Bukkit.getConsoleSender().sendMessage(Utils.translate("&2[TheGlow] Done and enabled in %time%ms".replace("%time%", TheGlow.nanosToMillis(System.nanoTime() - l))));
    }

    public static String nanosToMillis(long l) {
        return NUMBER_FORMAT_NANO.format((double)l / 1000000.0);
    }

    @Override
    public void setupCommands() {
        this.reloadDynamicCommands();
    }

    public void reloadDynamicCommands() {
        this.getLogger().info("Reloading dynamic commands...");
        if (!this.fixedRegisteredCommands.isEmpty()) {
            this.getLogger().info("Removing previously registered commands: " + this.fixedRegisteredCommands);
            for (String object : this.fixedRegisteredCommands) {
                AbstractCommand.removeCommand(object);
            }
            this.fixedRegisteredCommands.clear();
        } else {
            this.getLogger().info("No previously registered commands found.");
        }
        this.registerCommand("config.command.shortened-open-command", xshyo.us.theglow.C.A.class, "Open glow menu", "Use /glow");
        if (this.conf.getBoolean("config.command.default.enabled").booleanValue()) {
            String string = this.conf.getString("config.command.default.name");
            List<String> list = this.conf.getStringList("config.command.default.aliases");
            this.getLogger().info("Registering main command: " + (String)string + ", aliases: " + list);
            new DynamicCommand(string, "/" + (String)string + " <arg>", "Main glow command", list, new xshyo.us.theglow.B()).register();
            this.fixedRegisteredCommands.add(string.toLowerCase());
        }
    }

    private void registerCommand(String string, Class<?> clazz, String string2, String string3) {
        if (!this.conf.getBoolean(string + ".enabled").booleanValue()) {
            return;
        }
        String string4 = this.conf.getString(string + ".name");
        List<String> list = this.conf.getStringList(string + ".aliases");
        this.getLogger().info("Registering command: " + string4 + ", aliases: " + list);
        try {
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class, List.class);
            AbstractCommand abstractCommand = (AbstractCommand)constructor.newInstance(string4, string2, string3, list);
            abstractCommand.register();
            this.fixedRegisteredCommands.add(string4.toLowerCase());
        }
        catch (Exception exception) {
            this.getLogger().log(Level.SEVERE, "Failed to register command: " + string4 + " from class " + clazz.getSimpleName(), exception);
        }
    }

    public void Hooks() {
        this.getLogger().log(Level.INFO, "Registering Hooks...");
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        Plugin plugin = pluginManager.getPlugin("PlaceholderAPI");
        if (plugin != null && plugin.isEnabled()) {
            new xshyo.us.theglow.G.A().register();
            this.getLogger().log(Level.INFO, "Hooked onto PlaceholderAPI");
        } else {
            this.getLogger().log(Level.WARNING, "PlaceholderAPI not found! Not enabling placeholders! Download and install it from https://www.spigotmc.org/resources/6245/");
        }
    }

    public void reload() {
        try {
            this.lang.reload();
            this.conf.reload();
            this.menus.reload();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.reloadDynamicCommands();
        this.glowLoad.B();
    }

    @Override
    public void stop() {
        this.getScheduler().cancelTasks((Plugin)this);
        if (this.glowManager != null) {
            this.glowManager.C();
        }
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    private void setupMetrics() {
        this.getLogger().log(Level.INFO, "Registering Metrics...");
        int n = 23345;
        new Metrics((Plugin)this, n);
    }

    @NonNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public BukkitAudiences getAdventure() {
        return this.adventure;
    }

    public YamlDocument getLang() {
        return this.lang;
    }

    public YamlDocument getConf() {
        return this.conf;
    }

    public YamlDocument getMenus() {
        return this.menus;
    }

    @Override
    public List<CommandArg> getCommandArgs() {
        return this.commandArgs;
    }

    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    public xshyo.us.theglow.I.A getDatabase() {
        return this.database;
    }

    public xshyo.us.theglow.E.C getGlowManager() {
        return this.glowManager;
    }

    public xshyo.us.theglow.E.A getGlowLoad() {
        return this.glowLoad;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getNewUpdateVersion() {
        return this.newUpdateVersion;
    }

    public String getUpdateDescription() {
        return this.UpdateDescription;
    }

    public xshyo.us.theglow.J.A getPluginIntegrationManager() {
        return this.pluginIntegrationManager;
    }

    public List<String> getFixedRegisteredCommands() {
        return this.fixedRegisteredCommands;
    }

    public static TheGlow getInstance() {
        return instance;
    }

    static {
        NUMBER_FORMAT_NANO = new DecimalFormat("0.00");
    }
}

