/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.block.implementation.Section;
import xshyo.us.theglow.libs.config.engine.ExtendedConstructor;
import xshyo.us.theglow.libs.config.engine.ExtendedRepresenter;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.StreamDataWriter;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.composer.Composer;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.emitter.Emitter;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.parser.ParserImpl;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner.StreamReader;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.serializer.Serializer;
import xshyo.us.theglow.libs.config.settings.Settings;
import xshyo.us.theglow.libs.config.settings.dumper.DumperSettings;
import xshyo.us.theglow.libs.config.settings.general.GeneralSettings;
import xshyo.us.theglow.libs.config.settings.loader.LoaderSettings;
import xshyo.us.theglow.libs.config.settings.updater.UpdaterSettings;
import xshyo.us.theglow.libs.config.updater.Updater;

public class YamlDocument
extends Section {
    private final File file;
    private final YamlDocument defaults;
    private GeneralSettings generalSettings;
    private LoaderSettings loaderSettings;
    private DumperSettings dumperSettings;
    private UpdaterSettings updaterSettings;

    protected YamlDocument(@NotNull InputStream inputStream, @Nullable InputStream inputStream2, Settings ... settingsArray) throws IOException {
        super(Collections.emptyMap());
        this.setSettingsInternal(settingsArray);
        this.setValue(this.generalSettings.getDefaultMap());
        this.file = null;
        this.defaults = inputStream2 == null ? null : new YamlDocument(inputStream2, null, settingsArray);
        this.reload(inputStream);
    }

    protected YamlDocument(@NotNull File file, @Nullable InputStream inputStream, Settings ... settingsArray) throws IOException {
        super(Collections.emptyMap());
        this.setSettingsInternal(settingsArray);
        this.setValue(this.generalSettings.getDefaultMap());
        this.file = file;
        this.defaults = inputStream == null ? null : new YamlDocument(inputStream, null, this.generalSettings, this.loaderSettings, this.dumperSettings, this.updaterSettings);
        this.reload();
    }

    private void setSettingsInternal(Settings ... settingsArray) {
        for (Settings settings : settingsArray) {
            if (settings instanceof GeneralSettings) {
                if (this.generalSettings != null && this.generalSettings.getKeyFormat() != ((GeneralSettings)settings).getKeyFormat()) {
                    throw new IllegalArgumentException("Cannot change the key format! Recreate the file if needed to do so.");
                }
                this.generalSettings = (GeneralSettings)settings;
                continue;
            }
            if (settings instanceof LoaderSettings) {
                this.loaderSettings = (LoaderSettings)settings;
                continue;
            }
            if (settings instanceof DumperSettings) {
                this.dumperSettings = (DumperSettings)settings;
                continue;
            }
            if (settings instanceof UpdaterSettings) {
                this.updaterSettings = (UpdaterSettings)settings;
                continue;
            }
            throw new IllegalArgumentException("Unknown settings object!");
        }
        this.generalSettings = this.generalSettings == null ? GeneralSettings.DEFAULT : this.generalSettings;
        this.loaderSettings = this.loaderSettings == null ? LoaderSettings.DEFAULT : this.loaderSettings;
        this.dumperSettings = this.dumperSettings == null ? DumperSettings.DEFAULT : this.dumperSettings;
        this.updaterSettings = this.updaterSettings == null ? UpdaterSettings.DEFAULT : this.updaterSettings;
    }

    public boolean reload() throws IOException {
        if (this.file == null) {
            return false;
        }
        this.reload(this.file);
        return true;
    }

    private void reload(@NotNull File file) throws IOException {
        this.clear();
        if (Objects.requireNonNull(file, "File cannot be null!").exists()) {
            this.reload(new BufferedInputStream(new FileInputStream(file)));
            return;
        }
        if (this.loaderSettings.isCreateFileIfAbsent()) {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            file.createNewFile();
        }
        if (this.defaults == null) {
            this.initEmpty(this);
            return;
        }
        String string = this.defaults.dump();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8));){
            bufferedWriter.write(string);
        }
        this.reload(new BufferedInputStream(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8))));
    }

    public void reload(@NotNull InputStream inputStream) throws IOException {
        this.reload(inputStream, this.loaderSettings);
    }

    public void reload(@NotNull InputStream inputStream, @NotNull LoaderSettings loaderSettings) throws IOException {
        this.clear();
        LoadSettings loadSettings = Objects.requireNonNull(loaderSettings, "Loader settings cannot be null!").buildEngineSettings(this.generalSettings);
        ExtendedConstructor extendedConstructor = new ExtendedConstructor(loadSettings, this.generalSettings.getSerializer());
        ParserImpl parserImpl = new ParserImpl(loadSettings, new StreamReader(loadSettings, new YamlUnicodeReader(Objects.requireNonNull(inputStream, "Input stream cannot be null!"))));
        Composer composer = new Composer(loadSettings, parserImpl);
        if (composer.hasNext()) {
            Node node = composer.next();
            if (composer.hasNext()) {
                throw new InvalidObjectException("Multiple documents are not supported!");
            }
            if (!(node instanceof MappingNode)) {
                throw new IllegalArgumentException(String.format("Top level object is not a map! Parsed node: %s", node.toString()));
            }
            extendedConstructor.constructSingleDocument(Optional.of(node));
            this.init(this, null, (MappingNode)node, extendedConstructor);
            extendedConstructor.clear();
        } else {
            this.initEmpty(this);
        }
        if (this.file != null && loaderSettings.isCreateFileIfAbsent() && !this.file.exists()) {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            this.file.createNewFile();
            this.save();
        }
        if (this.defaults != null && loaderSettings.isAutoUpdate()) {
            Updater.update(this, this.defaults, this.updaterSettings, this.generalSettings);
        }
    }

    public boolean update() throws IOException {
        return this.update(this.updaterSettings);
    }

    public boolean update(@NotNull UpdaterSettings updaterSettings) throws IOException {
        if (this.defaults == null) {
            return false;
        }
        Updater.update(this, this.defaults, Objects.requireNonNull(updaterSettings, "Updater settings cannot be null!"), this.generalSettings);
        return true;
    }

    public void update(@NotNull InputStream inputStream) throws IOException {
        this.update(inputStream, this.updaterSettings);
    }

    public void update(@NotNull InputStream inputStream, @NotNull UpdaterSettings updaterSettings) throws IOException {
        Updater.update(this, YamlDocument.create(Objects.requireNonNull(inputStream, "Defaults cannot be null!"), this.generalSettings, this.loaderSettings, this.dumperSettings, UpdaterSettings.DEFAULT), Objects.requireNonNull(updaterSettings, "Updater settings cannot be null!"), this.generalSettings);
    }

    public boolean save() throws IOException {
        if (this.file == null) {
            return false;
        }
        this.save(this.file);
        return true;
    }

    public void save(@NotNull File file) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8));){
            bufferedWriter.write(this.dump());
        }
    }

    public void save(@NotNull OutputStream outputStream, Charset charset) throws IOException {
        outputStream.write(this.dump().getBytes(charset));
    }

    public void save(@NotNull OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write(this.dump());
    }

    public String dump() {
        return this.dump(this.dumperSettings);
    }

    public String dump(@NotNull DumperSettings dumperSettings) {
        DumpSettings dumpSettings = dumperSettings.buildEngineSettings();
        SerializedStream serializedStream = new SerializedStream();
        ExtendedRepresenter extendedRepresenter = new ExtendedRepresenter(this.generalSettings, dumperSettings, dumpSettings);
        Serializer serializer = new Serializer(dumpSettings, new Emitter(dumpSettings, serializedStream));
        serializer.emitStreamStart();
        serializer.serializeDocument(extendedRepresenter.represent(this));
        serializer.emitStreamEnd();
        return serializedStream.toString();
    }

    public void setSettings(Settings ... settingsArray) {
        this.setSettingsInternal(settingsArray);
    }

    @Deprecated
    public void setLoaderSettings(@NotNull LoaderSettings loaderSettings) {
        this.loaderSettings = loaderSettings;
    }

    public void setDumperSettings(@NotNull DumperSettings dumperSettings) {
        this.dumperSettings = dumperSettings;
    }

    public void setGeneralSettings(@NotNull GeneralSettings generalSettings) {
        if (generalSettings.getKeyFormat() != this.generalSettings.getKeyFormat()) {
            throw new IllegalArgumentException("Cannot change key format! Recreate the file if needed to do so.");
        }
        this.generalSettings = generalSettings;
    }

    public void setUpdaterSettings(@NotNull UpdaterSettings updaterSettings) {
        this.updaterSettings = updaterSettings;
    }

    @Override
    @Nullable
    public YamlDocument getDefaults() {
        return this.defaults;
    }

    @NotNull
    public GeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    @NotNull
    public DumperSettings getDumperSettings() {
        return this.dumperSettings;
    }

    @NotNull
    public UpdaterSettings getUpdaterSettings() {
        return this.updaterSettings;
    }

    @NotNull
    public LoaderSettings getLoaderSettings() {
        return this.loaderSettings;
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    public static YamlDocument create(@NotNull File file, @NotNull InputStream inputStream, Settings ... settingsArray) throws IOException {
        return new YamlDocument(file, inputStream, settingsArray);
    }

    public static YamlDocument create(@NotNull InputStream inputStream, @NotNull InputStream inputStream2, Settings ... settingsArray) throws IOException {
        return new YamlDocument(inputStream, inputStream2, settingsArray);
    }

    public static YamlDocument create(@NotNull File file, Settings ... settingsArray) throws IOException {
        return new YamlDocument(file, null, settingsArray);
    }

    public static YamlDocument create(@NotNull InputStream inputStream, Settings ... settingsArray) throws IOException {
        return new YamlDocument(inputStream, null, settingsArray);
    }

    private static class SerializedStream
    extends StringWriter
    implements StreamDataWriter {
        private SerializedStream() {
        }
    }
}

