/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.block;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.block.Comments;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.utils.format.NodeRole;

public abstract class Block<T> {
    @Nullable
    List<CommentLine> beforeKeyComments = null;
    @Nullable
    List<CommentLine> inlineKeyComments = null;
    @Nullable
    List<CommentLine> afterKeyComments = null;
    @Nullable
    List<CommentLine> beforeValueComments = null;
    @Nullable
    List<CommentLine> inlineValueComments = null;
    @Nullable
    List<CommentLine> afterValueComments = null;
    private T value;
    private boolean ignored;

    public Block(@Nullable Node node, @Nullable Node node2, @Nullable T t) {
        this.value = t;
        this.init(node, node2);
    }

    public Block(@Nullable T t) {
        this(null, null, t);
    }

    public Block(@Nullable Block<?> block, @Nullable T t) {
        this.value = t;
        if (block == null) {
            return;
        }
        this.beforeKeyComments = block.beforeKeyComments;
        this.inlineKeyComments = block.inlineKeyComments;
        this.afterKeyComments = block.afterKeyComments;
        this.beforeValueComments = block.beforeValueComments;
        this.inlineValueComments = block.inlineValueComments;
        this.afterValueComments = block.afterValueComments;
    }

    protected void init(@Nullable Node node, @Nullable Node node2) {
        if (node != null) {
            this.beforeKeyComments = node.getBlockComments() == null ? new ArrayList(0) : node.getBlockComments();
            this.inlineKeyComments = node.getInLineComments();
            this.afterKeyComments = node.getEndComments();
            this.collectComments(node, this.beforeKeyComments, true);
        }
        if (node2 != null) {
            this.beforeValueComments = node2.getBlockComments() == null ? new ArrayList(0) : node2.getBlockComments();
            this.inlineValueComments = node2.getInLineComments();
            this.afterValueComments = node2.getEndComments();
            this.collectComments(node2, this.beforeValueComments, true);
        }
    }

    private void collectComments(@NotNull Node node, @NotNull List<CommentLine> list, boolean bl) {
        block7: {
            block6: {
                if (!bl) {
                    if (node.getBlockComments() != null) {
                        list.addAll(this.toBlockComments(node.getBlockComments()));
                    }
                    if (node.getInLineComments() != null) {
                        list.addAll(this.toBlockComments(node.getInLineComments()));
                    }
                    if (node.getEndComments() != null) {
                        list.addAll(this.toBlockComments(node.getEndComments()));
                    }
                }
                if (!(node instanceof SequenceNode)) break block6;
                SequenceNode sequenceNode = (SequenceNode)node;
                for (Node node2 : sequenceNode.getValue()) {
                    this.collectComments(node2, list, false);
                }
                break block7;
            }
            if (bl || !(node instanceof MappingNode)) break block7;
            MappingNode mappingNode = (MappingNode)node;
            for (NodeTuple nodeTuple : mappingNode.getValue()) {
                this.collectComments(nodeTuple.getKeyNode(), list, false);
                this.collectComments(nodeTuple.getValueNode(), list, false);
            }
        }
    }

    private List<CommentLine> toBlockComments(@NotNull List<CommentLine> list) {
        int n = -1;
        for (CommentLine commentLine : list) {
            list.set(++n, commentLine.getCommentType() != CommentType.IN_LINE ? commentLine : new CommentLine(commentLine.getStartMark(), commentLine.getEndMark(), commentLine.getValue(), CommentType.BLOCK));
        }
        return list;
    }

    public void setValue(T t) {
        this.value = t;
    }

    @Nullable
    public List<String> getComments() {
        List<CommentLine> list = Comments.get(this, NodeRole.KEY, Comments.Position.BEFORE);
        if (list == null) {
            return null;
        }
        return list.stream().map(CommentLine::getValue).collect(Collectors.toList());
    }

    public void setComments(@Nullable List<String> list) {
        Comments.set(this, NodeRole.KEY, Comments.Position.BEFORE, list == null ? null : list.stream().map(string -> Comments.create(string, Comments.Position.BEFORE)).collect(Collectors.toList()));
    }

    public void removeComments() {
        Comments.remove(this, NodeRole.KEY, Comments.Position.BEFORE);
    }

    public void addComments(@NotNull List<String> list) {
        Comments.add(this, NodeRole.KEY, Comments.Position.BEFORE, list.stream().map(string -> Comments.create(string, Comments.Position.BEFORE)).collect(Collectors.toList()));
    }

    public void addComment(@NotNull String string) {
        Comments.add(this, NodeRole.KEY, Comments.Position.BEFORE, Comments.create(string, Comments.Position.BEFORE));
    }

    public void setIgnored(boolean bl) {
        this.ignored = bl;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public abstract boolean isSection();

    public T getStoredValue() {
        return this.value;
    }
}

