/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.block.Block;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentType;
import xshyo.us.theglow.libs.config.utils.format.NodeRole;

public class Comments {
    public static final CommentLine BLANK_LINE = new CommentLine(Optional.empty(), Optional.empty(), "", CommentType.BLANK_LINE);

    @Nullable
    public static List<CommentLine> get(@NotNull Block<?> block, @NotNull NodeRole nodeRole, @NotNull Position position) {
        switch (position) {
            case BEFORE: {
                return nodeRole == NodeRole.KEY ? block.beforeKeyComments : block.beforeValueComments;
            }
            case INLINE: {
                return nodeRole == NodeRole.KEY ? block.inlineKeyComments : block.inlineValueComments;
            }
            case AFTER: {
                return nodeRole == NodeRole.KEY ? block.afterKeyComments : block.afterValueComments;
            }
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static List<CommentLine> get(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position) {
        return Comments.get(block, nodeType.toRole(), position);
    }

    public static void set(@NotNull Block<?> block, @NotNull NodeRole nodeRole, @NotNull Position position, @Nullable List<CommentLine> list) {
        if (list != null) {
            list = new ArrayList<CommentLine>(list);
        }
        switch (position) {
            case BEFORE: {
                if (nodeRole == NodeRole.KEY) {
                    block.beforeKeyComments = list;
                    break;
                }
                block.beforeValueComments = list;
                break;
            }
            case INLINE: {
                if (nodeRole == NodeRole.KEY) {
                    block.inlineKeyComments = list;
                    break;
                }
                block.inlineValueComments = list;
                break;
            }
            case AFTER: {
                if (nodeRole == NodeRole.KEY) {
                    block.afterKeyComments = list;
                    break;
                }
                block.afterValueComments = list;
            }
        }
    }

    @Deprecated
    public static void set(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position, @Nullable List<CommentLine> list) {
        Comments.set(block, nodeType.toRole(), position, list);
    }

    public static void remove(@NotNull Block<?> block, @NotNull NodeRole nodeRole, @NotNull Position position) {
        Comments.set(block, nodeRole, position, null);
    }

    @Deprecated
    public static void remove(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position) {
        Comments.set(block, nodeType.toRole(), position, null);
    }

    public static void add(@NotNull Block<?> block, @NotNull NodeRole nodeRole, @NotNull Position position, @NotNull List<CommentLine> list) {
        list.forEach(commentLine -> Comments.add(block, nodeRole, position, commentLine));
    }

    @Deprecated
    public static void add(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position, @NotNull List<CommentLine> list) {
        list.forEach(commentLine -> Comments.add(block, nodeType.toRole(), position, commentLine));
    }

    public static void add(@NotNull Block<?> block, @NotNull NodeRole nodeRole, @NotNull Position position, @NotNull CommentLine commentLine) {
        switch (position) {
            case BEFORE: {
                if (nodeRole == NodeRole.KEY) {
                    if (block.beforeKeyComments == null) {
                        block.beforeKeyComments = new ArrayList<CommentLine>();
                    }
                    block.beforeKeyComments.add(commentLine);
                    break;
                }
                if (block.beforeValueComments == null) {
                    block.beforeValueComments = new ArrayList<CommentLine>();
                }
                block.beforeValueComments.add(commentLine);
                break;
            }
            case INLINE: {
                if (nodeRole == NodeRole.KEY) {
                    if (block.inlineKeyComments == null) {
                        block.inlineKeyComments = new ArrayList<CommentLine>();
                    }
                    block.inlineKeyComments.add(commentLine);
                    break;
                }
                if (block.inlineValueComments == null) {
                    block.inlineValueComments = new ArrayList<CommentLine>();
                }
                block.inlineValueComments.add(commentLine);
                break;
            }
            case AFTER: {
                if (nodeRole == NodeRole.KEY) {
                    if (block.afterKeyComments == null) {
                        block.afterKeyComments = new ArrayList<CommentLine>();
                    }
                    block.afterKeyComments.add(commentLine);
                    break;
                }
                if (block.afterValueComments == null) {
                    block.afterValueComments = new ArrayList<CommentLine>();
                }
                block.afterValueComments.add(commentLine);
            }
        }
    }

    @Deprecated
    public static void add(@NotNull Block<?> block, @NotNull NodeType nodeType, @NotNull Position position, @NotNull CommentLine commentLine) {
        Comments.add(block, nodeType.toRole(), position, commentLine);
    }

    @NotNull
    public static CommentLine create(@NotNull String string, @NotNull Position position) {
        return new CommentLine(Optional.empty(), Optional.empty(), string, position == Position.INLINE ? CommentType.IN_LINE : CommentType.BLOCK);
    }

    public static enum NodeType {
        KEY,
        VALUE;


        public NodeRole toRole() {
            return this == KEY ? NodeRole.KEY : NodeRole.VALUE;
        }
    }

    public static enum Position {
        BEFORE,
        INLINE,
        AFTER;

    }
}

