/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.dvs;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.dvs.Pattern;

public class Version
implements Comparable<Version> {
    private final Pattern pattern;
    private final int[] cursors;
    private String id;

    Version(@Nullable String string, @NotNull Pattern pattern, int[] nArray) {
        this.id = string;
        this.pattern = pattern;
        this.cursors = nArray;
        if (string == null) {
            this.buildID();
        }
    }

    @Override
    public int compareTo(Version version) {
        if (!this.pattern.equals(version.pattern)) {
            throw new ClassCastException("Compared versions are not defined by the same pattern!");
        }
        for (int i = 0; i < this.cursors.length; ++i) {
            int n = Integer.compare(this.cursors[i], version.cursors[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public int getCursor(int n) {
        return this.cursors[n];
    }

    public void next() {
        for (int i = this.cursors.length - 1; i >= 0; --i) {
            int n = this.cursors[i];
            if (n + 1 < this.pattern.getSegment(i).length()) {
                this.cursors[i] = n + 1;
                break;
            }
            this.cursors[i] = 0;
        }
        this.buildID();
    }

    private void buildID() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.cursors.length; ++i) {
            stringBuilder.append(this.pattern.getSegment(i).getElement(this.cursors[i]));
        }
        this.id = stringBuilder.toString();
    }

    public String asID() {
        return this.id;
    }

    public Version copy() {
        return new Version(this.id, this.pattern, Arrays.copyOf(this.cursors, this.cursors.length));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.pattern.equals(version.pattern) && Arrays.equals(this.cursors, version.cursors);
    }

    public int hashCode() {
        int n = Objects.hash(this.pattern);
        n = 31 * n + Arrays.hashCode(this.cursors);
        return n;
    }

    public String toString() {
        return "Version{pattern=" + this.pattern + ", cursors=" + Arrays.toString(this.cursors) + ", id='" + this.id + '\'' + '}';
    }
}

