/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.dvs.segment;

import java.util.Arrays;
import xshyo.us.theglow.libs.config.dvs.segment.Segment;

public class RangeSegment
implements Segment {
    private final int start;
    private final int end;
    private final int step;
    private final int minStringLength;
    private final int maxStringLength;
    private final int fill;
    private final int length;

    public RangeSegment(int n, int n2, int n3, int n4) {
        this.start = n;
        this.end = n2;
        this.step = n3;
        this.fill = n4;
        if (n3 == 0) {
            throw new IllegalArgumentException("Step cannot be zero!");
        }
        if (n < n2 && n3 < 0 || n > n2 && n3 > 0) {
            throw new IllegalArgumentException(String.format("Invalid step for the given range! start=%d end=%d step=%d", n, n2, n3));
        }
        if (n == n2) {
            throw new IllegalArgumentException(String.format("Parameters define an empty range, start=end! start=%d end=%d", n, n2));
        }
        this.length = (int)Math.ceil((double)Math.abs(n - n2) / (double)Math.abs(n3));
        int n5 = n + n3 * (this.length - 1);
        if (n < 0 || n2 < 0 && n5 < 0) {
            throw new IllegalArgumentException(String.format("Range contains negative integers! start=%d end=%d step=%d", n, n2, n3));
        }
        if (n4 > 0 && !this.validateFill(n4, Math.max(n, n5))) {
            throw new IllegalArgumentException(String.format("Some integer from the range exceeds maximum length defined by the filling parameter! start=%d end=%d last=%d fill=%d", n, n2, n5, n4));
        }
        int n6 = n4 > 0 ? n4 : (this.maxStringLength = this.countDigits(n3 > 0 ? n2 : n));
        this.minStringLength = n4 > 0 ? n4 : this.countDigits(n3 > 0 ? n : n2);
    }

    @Deprecated
    public RangeSegment(int n, int n2) {
        this(n, n2, n < n2 ? 1 : -1, 0);
    }

    @Deprecated
    public RangeSegment(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    private boolean validateFill(int n, int n2) {
        int n3 = 9;
        for (int i = 0; i < n; ++i) {
            if (n3 >= n2) {
                return true;
            }
            n3 *= 10;
            n3 += 9;
        }
        return false;
    }

    @Override
    public int parse(String string, int n) {
        int n2;
        int n3;
        if (this.fill > 0) {
            if (this.fill > string.length() - n) {
                return -1;
            }
            try {
                return this.getRangeIndex(Integer.parseInt(string.substring(n, this.fill)));
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        if (string.length() <= n) {
            return -1;
        }
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < this.maxStringLength && n2 < string.length() - n && (n2 != 1 || n4 != 0 || n5 != 1) && (n3 = Character.digit(string.charAt(n + n2), 10)) != -1; n4 += n3, ++n5, ++n2) {
            n4 *= 10;
        }
        if (n5 == 0) {
            return -1;
        }
        if (n4 == 0) {
            return this.getRangeIndex(0);
        }
        while (n4 > 0 && n5 >= this.minStringLength) {
            n2 = this.getRangeIndex(n4);
            if (n2 != -1) {
                return n2;
            }
            n4 /= 10;
            --n5;
        }
        return -1;
    }

    private int countDigits(int n) {
        if (n == 0) {
            return 1;
        }
        int n2 = 0;
        while (n > 0) {
            n /= 10;
            ++n2;
        }
        return n2;
    }

    private int getRangeIndex(int n) {
        if (this.step > 0 ? this.start > n || this.end <= n : this.start < n || this.end >= n) {
            return -1;
        }
        int n2 = Math.abs(n - this.start);
        if (n >= 0 && n2 % this.step == 0) {
            return n2 / Math.abs(this.step);
        }
        return -1;
    }

    @Override
    public String getElement(int n) {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds! i=%d length=%d", n, this.length));
        }
        String string = Integer.toString(this.start + this.step * n, 10);
        if (this.fill <= 0 || string.length() == this.fill) {
            return string;
        }
        char[] cArray = new char[this.fill - string.length()];
        Arrays.fill(cArray, '0');
        return new StringBuilder(string).insert(0, cArray).toString();
    }

    @Override
    public int getElementLength(int n) {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException(String.format("Index out of bounds! i=%d length=%d", n, this.length));
        }
        return this.fill > 0 ? this.fill : this.countDigits(this.start + this.step * n);
    }

    @Override
    public int length() {
        return this.length;
    }

    public String toString() {
        return "RangeSegment{start=" + this.start + ", end=" + this.end + ", step=" + this.step + ", fill=" + this.fill + ", length=" + this.length + '}';
    }
}

