/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.engine;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.constructor.StandardConstructor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.serialization.YamlSerializer;

public class ExtendedConstructor
extends StandardConstructor {
    private final YamlSerializer serializer;
    private final Map<Node, Object> constructed = new HashMap<Node, Object>();

    public ExtendedConstructor(@NotNull LoadSettings loadSettings, @NotNull YamlSerializer yamlSerializer) {
        super(loadSettings);
        this.serializer = yamlSerializer;
        this.tagConstructors.put(Tag.MAP, new ConstructMap((StandardConstructor.ConstructYamlMap)this.tagConstructors.get(Tag.MAP)));
    }

    @Override
    protected Object construct(Node node) {
        Object object = super.construct(node);
        this.constructed.put(node, object);
        return object;
    }

    @Override
    protected Object constructObjectNoCheck(Node node) {
        Object object = super.constructObjectNoCheck(node);
        this.constructed.put(node, object);
        return object;
    }

    @NotNull
    public Object getConstructed(@NotNull Node node) {
        return this.constructed.get(node);
    }

    public void clear() {
        this.constructed.clear();
    }

    private class ConstructMap
    extends StandardConstructor.ConstructYamlMap {
        private final StandardConstructor.ConstructYamlMap previous;

        private ConstructMap(StandardConstructor.ConstructYamlMap constructYamlMap) {
            super(ExtendedConstructor.this);
            this.previous = constructYamlMap;
        }

        @Override
        public Object construct(Node node) {
            Map map = (Map)this.previous.construct(node);
            Object object = ExtendedConstructor.this.serializer.deserialize(map);
            return object == null ? map : object;
        }
    }
}

