/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.YamlDocument;
import xshyo.us.theglow.libs.config.block.Block;
import xshyo.us.theglow.libs.config.block.Comments;
import xshyo.us.theglow.libs.config.block.implementation.Section;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.representer.StandardRepresenter;
import xshyo.us.theglow.libs.config.settings.dumper.DumperSettings;
import xshyo.us.theglow.libs.config.settings.general.GeneralSettings;
import xshyo.us.theglow.libs.config.utils.format.NodeRole;

public class ExtendedRepresenter
extends StandardRepresenter {
    private final GeneralSettings generalSettings;
    private final DumperSettings dumperSettings;
    private NodeRole nodeRole = NodeRole.KEY;

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumperSettings dumperSettings, @NotNull DumpSettings dumpSettings) {
        super(dumpSettings);
        this.generalSettings = generalSettings;
        this.dumperSettings = dumperSettings;
        RepresentSection representSection = new RepresentSection();
        RepresentSerializable representSerializable = new RepresentSerializable();
        this.representers.put(Section.class, representSection);
        this.representers.put(YamlDocument.class, representSection);
        this.representers.put(Enum.class, new RepresentEnum());
        this.representers.put(String.class, new RepresentString((RepresentToNode)this.representers.get(String.class)));
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedClasses()) {
            this.representers.put(clazz, representSerializable);
        }
        for (Class<?> clazz : generalSettings.getSerializer().getSupportedParentClasses()) {
            this.parentClassRepresenters.put(clazz, representSerializable);
        }
    }

    public ExtendedRepresenter(@NotNull GeneralSettings generalSettings, @NotNull DumperSettings dumperSettings) {
        this(generalSettings, dumperSettings, dumperSettings.buildEngineSettings());
    }

    @Override
    protected Node representScalar(Tag tag, String string, ScalarStyle scalarStyle) {
        return super.representScalar(tag, string, this.dumperSettings.getScalarFormatter().format(tag, string, this.nodeRole, scalarStyle));
    }

    @Override
    protected Node representSequence(Tag tag, Iterable<?> iterable, FlowStyle flowStyle) {
        return super.representSequence(tag, iterable, this.dumperSettings.getSequenceFormatter().format(tag, iterable, this.nodeRole, flowStyle));
    }

    @Override
    protected Node representMapping(Tag tag, Map<?, ?> map, FlowStyle flowStyle) {
        return super.representMapping(tag, map, this.dumperSettings.getMappingFormatter().format(tag, map, this.nodeRole, flowStyle));
    }

    private Node applyComments(@Nullable Block<?> block, @NotNull NodeRole nodeRole, @NotNull Node node, boolean bl) {
        List<CommentLine> list;
        if (block == null) {
            return node;
        }
        if (this.allowBlockComments(bl)) {
            node.setBlockComments(Comments.get(block, nodeRole, Comments.Position.BEFORE));
            node.setEndComments(Comments.get(block, nodeRole, Comments.Position.AFTER));
        }
        if ((list = Comments.get(block, nodeRole, Comments.Position.INLINE)) != null && !list.isEmpty()) {
            if (this.allowInlineComments(node)) {
                node.setInLineComments(list);
            } else if (this.allowBlockComments(bl)) {
                ArrayList<CommentLine> arrayList = node.getBlockComments() == null ? new ArrayList<CommentLine>(list.size()) : new ArrayList<CommentLine>(node.getBlockComments());
                for (CommentLine commentLine : list) {
                    arrayList.add(new CommentLine(commentLine.getStartMark(), commentLine.getEndMark(), commentLine.getValue(), commentLine.getCommentType() == CommentType.IN_LINE ? CommentType.BLOCK : commentLine.getCommentType()));
                }
                node.setBlockComments(arrayList);
            }
        }
        return node;
    }

    @Override
    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        Block block = entry.getValue() instanceof Block ? (Block)entry.getValue() : null;
        this.nodeRole = NodeRole.KEY;
        Node node = this.applyComments(block, this.nodeRole, this.representData(entry.getKey()), false);
        this.nodeRole = NodeRole.VALUE;
        Node node2 = this.applyComments(block, this.nodeRole, this.representData(block == null ? entry.getValue() : block.getStoredValue()), false);
        return new NodeTuple(node, node2);
    }

    private boolean allowBlockComments(boolean bl) {
        return bl || this.settings.getDefaultFlowStyle() == FlowStyle.BLOCK;
    }

    private boolean allowInlineComments(@NotNull Node node) {
        return this.settings.getDefaultFlowStyle() == FlowStyle.BLOCK && node instanceof ScalarNode || this.settings.getDefaultFlowStyle() == FlowStyle.FLOW && (node instanceof SequenceNode || node instanceof MappingNode);
    }

    private class RepresentString
    implements RepresentToNode {
        private final RepresentToNode previous;

        private RepresentString(RepresentToNode representToNode) {
            this.previous = representToNode;
        }

        @Override
        public Node representData(Object object) {
            ScalarStyle scalarStyle = ExtendedRepresenter.this.defaultScalarStyle;
            ExtendedRepresenter.this.defaultScalarStyle = ExtendedRepresenter.this.dumperSettings.getStringStyle();
            Node node = this.previous.representData(object);
            ExtendedRepresenter.this.defaultScalarStyle = scalarStyle;
            return node;
        }
    }

    private class RepresentEnum
    implements RepresentToNode {
        private RepresentEnum() {
        }

        @Override
        public Node representData(Object object) {
            return ExtendedRepresenter.this.representData(((Enum)object).name());
        }
    }

    private class RepresentSection
    implements RepresentToNode {
        private RepresentSection() {
        }

        @Override
        public Node representData(Object object) {
            Section section = (Section)object;
            return ExtendedRepresenter.this.applyComments(section, NodeRole.VALUE, ExtendedRepresenter.this.representData(section.getStoredValue()), section.isRoot());
        }
    }

    private class RepresentSerializable
    implements RepresentToNode {
        private RepresentSerializable() {
        }

        @Override
        public Node representData(Object map) {
            Map<Object, Object> map2 = ExtendedRepresenter.this.generalSettings.getSerializer().serialize(map, ExtendedRepresenter.this.generalSettings.getDefaultMapSupplier());
            return ExtendedRepresenter.this.representData(map2 == null ? map : map2);
        }
    }
}

