/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.SettingKey;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.EmitterException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.schema.JsonSchema;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.schema.Schema;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.serializer.AnchorGenerator;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.serializer.NumberAnchorGenerator;

public final class DumpSettingsBuilder {
    Map<SettingKey, Object> customProperties = new HashMap<SettingKey, Object>();
    private boolean explicitStart = false;
    private boolean explicitEnd = false;
    private NonPrintableStyle nonPrintableStyle;
    private Optional<Tag> explicitRootTag = Optional.empty();
    private AnchorGenerator anchorGenerator;
    private Optional<SpecVersion> yamlDirective;
    private Map<String, String> tagDirective = new HashMap<String, String>();
    private FlowStyle defaultFlowStyle;
    private ScalarStyle defaultScalarStyle;
    private boolean dereferenceAliases = false;
    private boolean canonical = false;
    private boolean multiLineFlow;
    private boolean useUnicodeEncoding = true;
    private int indent = 2;
    private int indicatorIndent = 0;
    private int width = 80;
    private String bestLineBreak = "\n";
    private boolean splitLines = true;
    private int maxSimpleKeyLength = 128;
    private boolean indentWithIndicator = false;
    private boolean dumpComments = false;
    private Schema schema;

    DumpSettingsBuilder() {
        this.anchorGenerator = new NumberAnchorGenerator(0);
        this.yamlDirective = Optional.empty();
        this.defaultFlowStyle = FlowStyle.AUTO;
        this.defaultScalarStyle = ScalarStyle.PLAIN;
        this.nonPrintableStyle = NonPrintableStyle.ESCAPE;
        this.schema = new JsonSchema();
    }

    public DumpSettingsBuilder setDefaultFlowStyle(FlowStyle flowStyle) {
        this.defaultFlowStyle = flowStyle;
        return this;
    }

    public DumpSettingsBuilder setDefaultScalarStyle(ScalarStyle scalarStyle) {
        this.defaultScalarStyle = scalarStyle;
        return this;
    }

    public DumpSettingsBuilder setExplicitStart(boolean bl) {
        this.explicitStart = bl;
        return this;
    }

    public DumpSettingsBuilder setAnchorGenerator(AnchorGenerator anchorGenerator) {
        Objects.requireNonNull(anchorGenerator, "anchorGenerator cannot be null");
        this.anchorGenerator = anchorGenerator;
        return this;
    }

    public DumpSettingsBuilder setExplicitRootTag(Optional<Tag> optional) {
        Objects.requireNonNull(optional, "explicitRootTag cannot be null");
        this.explicitRootTag = optional;
        return this;
    }

    public DumpSettingsBuilder setExplicitEnd(boolean bl) {
        this.explicitEnd = bl;
        return this;
    }

    public DumpSettingsBuilder setYamlDirective(Optional<SpecVersion> optional) {
        Objects.requireNonNull(optional, "yamlDirective cannot be null");
        this.yamlDirective = optional;
        return this;
    }

    public DumpSettingsBuilder setTagDirective(Map<String, String> map) {
        Objects.requireNonNull(map, "tagDirective cannot be null");
        this.tagDirective = map;
        return this;
    }

    public DumpSettingsBuilder setCanonical(boolean bl) {
        this.canonical = bl;
        return this;
    }

    public DumpSettingsBuilder setMultiLineFlow(boolean bl) {
        this.multiLineFlow = bl;
        return this;
    }

    public DumpSettingsBuilder setUseUnicodeEncoding(boolean bl) {
        this.useUnicodeEncoding = bl;
        return this;
    }

    public DumpSettingsBuilder setIndent(int n) {
        if (n < 1) {
            throw new EmitterException("Indent must be at least 1");
        }
        if (n > 10) {
            throw new EmitterException("Indent must be at most 10");
        }
        this.indent = n;
        return this;
    }

    public DumpSettingsBuilder setIndicatorIndent(int n) {
        if (n < 0) {
            throw new EmitterException("Indicator indent must be non-negative");
        }
        if (n > 9) {
            throw new EmitterException("Indicator indent must be at most Emitter.MAX_INDENT-1: 9");
        }
        this.indicatorIndent = n;
        return this;
    }

    public DumpSettingsBuilder setWidth(int n) {
        this.width = n;
        return this;
    }

    public DumpSettingsBuilder setBestLineBreak(String string) {
        Objects.requireNonNull(string, "bestLineBreak cannot be null");
        this.bestLineBreak = string;
        return this;
    }

    public DumpSettingsBuilder setSplitLines(boolean bl) {
        this.splitLines = bl;
        return this;
    }

    public DumpSettingsBuilder setMaxSimpleKeyLength(int n) {
        if (n > 1024) {
            throw new YamlEngineException("The simple key must not span more than 1024 stream characters. See https://yaml.org/spec/1.2/spec.html#id2798057");
        }
        this.maxSimpleKeyLength = n;
        return this;
    }

    public DumpSettingsBuilder setNonPrintableStyle(NonPrintableStyle nonPrintableStyle) {
        this.nonPrintableStyle = nonPrintableStyle;
        return this;
    }

    public DumpSettingsBuilder setCustomProperty(SettingKey settingKey, Object object) {
        this.customProperties.put(settingKey, object);
        return this;
    }

    public DumpSettingsBuilder setIndentWithIndicator(boolean bl) {
        this.indentWithIndicator = bl;
        return this;
    }

    public DumpSettingsBuilder setDumpComments(boolean bl) {
        this.dumpComments = bl;
        return this;
    }

    public DumpSettingsBuilder setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public DumpSettingsBuilder setDereferenceAliases(Boolean bl) {
        this.dereferenceAliases = bl;
        return this;
    }

    public DumpSettings build() {
        return new DumpSettings(this.explicitStart, this.explicitEnd, this.explicitRootTag, this.anchorGenerator, this.yamlDirective, this.tagDirective, this.defaultFlowStyle, this.defaultScalarStyle, this.nonPrintableStyle, this.schema, this.dereferenceAliases, this.canonical, this.multiLineFlow, this.useUnicodeEncoding, this.indent, this.indicatorIndent, this.width, this.bestLineBreak, this.splitLines, this.maxSimpleKeyLength, this.customProperties, this.indentWithIndicator, this.dumpComments);
    }
}

