/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.SettingKey;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.env.EnvConfig;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlVersionException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.schema.JsonSchema;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.schema.Schema;

public final class LoadSettingsBuilder {
    private final Map<SettingKey, Object> customProperties = new HashMap<SettingKey, Object>();
    private String label = "reader";
    private Map<Tag, ConstructNode> tagConstructors = new HashMap<Tag, ConstructNode>();
    private IntFunction<List<Object>> defaultList = ArrayList::new;
    private IntFunction<Set<Object>> defaultSet = LinkedHashSet::new;
    private IntFunction<Map<Object, Object>> defaultMap = LinkedHashMap::new;
    private UnaryOperator<SpecVersion> versionFunction = specVersion -> {
        if (specVersion.getMajor() != 1) {
            throw new YamlVersionException((SpecVersion)specVersion);
        }
        return specVersion;
    };
    private Integer bufferSize = 1024;
    private boolean allowDuplicateKeys = false;
    private boolean allowRecursiveKeys = false;
    private boolean parseComments = false;
    private int maxAliasesForCollections = 50;
    private boolean useMarks = true;
    private Optional<EnvConfig> envConfig = Optional.empty();
    private int codePointLimit = 0x300000;
    private Schema schema = new JsonSchema();

    LoadSettingsBuilder() {
    }

    public LoadSettingsBuilder setLabel(String string) {
        Objects.requireNonNull(string, "label cannot be null");
        this.label = string;
        return this;
    }

    public LoadSettingsBuilder setTagConstructors(Map<Tag, ConstructNode> map) {
        this.tagConstructors = map;
        return this;
    }

    public LoadSettingsBuilder setDefaultList(IntFunction<List<Object>> intFunction) {
        Objects.requireNonNull(intFunction, "defaultList cannot be null");
        this.defaultList = intFunction;
        return this;
    }

    public LoadSettingsBuilder setDefaultSet(IntFunction<Set<Object>> intFunction) {
        Objects.requireNonNull(intFunction, "defaultSet cannot be null");
        this.defaultSet = intFunction;
        return this;
    }

    public LoadSettingsBuilder setDefaultMap(IntFunction<Map<Object, Object>> intFunction) {
        Objects.requireNonNull(intFunction, "defaultMap cannot be null");
        this.defaultMap = intFunction;
        return this;
    }

    public LoadSettingsBuilder setBufferSize(Integer n) {
        this.bufferSize = n;
        return this;
    }

    public LoadSettingsBuilder setAllowDuplicateKeys(boolean bl) {
        this.allowDuplicateKeys = bl;
        return this;
    }

    public LoadSettingsBuilder setAllowRecursiveKeys(boolean bl) {
        this.allowRecursiveKeys = bl;
        return this;
    }

    public LoadSettingsBuilder setMaxAliasesForCollections(int n) {
        this.maxAliasesForCollections = n;
        return this;
    }

    public LoadSettingsBuilder setUseMarks(boolean bl) {
        this.useMarks = bl;
        return this;
    }

    public LoadSettingsBuilder setVersionFunction(UnaryOperator<SpecVersion> unaryOperator) {
        Objects.requireNonNull(unaryOperator, "versionFunction cannot be null");
        this.versionFunction = unaryOperator;
        return this;
    }

    public LoadSettingsBuilder setEnvConfig(Optional<EnvConfig> optional) {
        this.envConfig = optional;
        return this;
    }

    public LoadSettingsBuilder setCustomProperty(SettingKey settingKey, Object object) {
        this.customProperties.put(settingKey, object);
        return this;
    }

    public LoadSettingsBuilder setParseComments(boolean bl) {
        this.parseComments = bl;
        return this;
    }

    public LoadSettingsBuilder setCodePointLimit(int n) {
        this.codePointLimit = n;
        return this;
    }

    public LoadSettingsBuilder setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public LoadSettings build() {
        return new LoadSettings(this.label, this.tagConstructors, this.defaultList, this.defaultSet, this.defaultMap, this.versionFunction, this.bufferSize, this.allowDuplicateKeys, this.allowRecursiveKeys, this.maxAliasesForCollections, this.useMarks, this.customProperties, this.envConfig, this.parseComments, this.codePointLimit, this.schema);
    }
}

