/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class YamlUnicodeReader
extends Reader {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Charset UTF16BE = StandardCharsets.UTF_16BE;
    private static final Charset UTF16LE = StandardCharsets.UTF_16LE;
    private static final Charset UTF32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF32LE = Charset.forName("UTF-32LE");
    private static final int BOM_SIZE = 4;
    PushbackInputStream internalIn;
    InputStreamReader internalIn2 = null;
    Charset encoding = UTF8;

    public YamlUnicodeReader(InputStream inputStream) {
        this.internalIn = new PushbackInputStream(inputStream, 4);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    protected void init() throws IOException {
        int n;
        if (this.internalIn2 != null) {
            return;
        }
        byte[] byArray = new byte[4];
        int n2 = this.internalIn.read(byArray, 0, byArray.length);
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            this.encoding = UTF32BE;
            n = n2 - 4;
        } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            this.encoding = UTF32LE;
            n = n2 - 4;
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.encoding = UTF8;
            n = n2 - 3;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            this.encoding = UTF16BE;
            n = n2 - 2;
        } else if (byArray[0] == -1 && byArray[1] == -2) {
            this.encoding = UTF16LE;
            n = n2 - 2;
        } else {
            this.encoding = UTF8;
            n = n2;
        }
        if (n > 0) {
            this.internalIn.unread(byArray, n2 - n, n);
        }
        CharsetDecoder charsetDecoder = this.encoding.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT);
        this.internalIn2 = new InputStreamReader((InputStream)this.internalIn, charsetDecoder);
    }

    @Override
    public void close() throws IOException {
        this.init();
        this.internalIn2.close();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.init();
        return this.internalIn2.read(cArray, n, n2);
    }
}

