/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CharConstants {
    private static final String ALPHA_S = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_";
    private static final String LINEBR_S = "\n";
    private static final String FULL_LINEBR_S = "\r\n";
    private static final String NULL_OR_LINEBR_S = "\u0000\r\n";
    private static final String NULL_BL_LINEBR_S = " \u0000\r\n";
    private static final String NULL_BL_T_LINEBR_S = "\t \u0000\r\n";
    private static final String NULL_BL_T_S = "\u0000 \t";
    private static final String URI_CHARS_SUFFIX_S = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_-;/?:@&=+$_.!~*'()%";
    public static final CharConstants LINEBR = new CharConstants("\n");
    public static final CharConstants NULL_OR_LINEBR = new CharConstants("\u0000\r\n");
    public static final CharConstants NULL_BL_LINEBR = new CharConstants(" \u0000\r\n");
    public static final CharConstants NULL_BL_T_LINEBR = new CharConstants("\t \u0000\r\n");
    public static final CharConstants NULL_BL_T = new CharConstants("\u0000 \t");
    public static final CharConstants URI_CHARS_FOR_TAG_PREFIX = new CharConstants("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_-;/?:@&=+$_.!~*'()%,[]");
    public static final CharConstants URI_CHARS_FOR_TAG_SUFFIX = new CharConstants("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_-;/?:@&=+$_.!~*'()%");
    public static final CharConstants ALPHA = new CharConstants("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_");
    private static final int ASCII_SIZE = 128;
    boolean[] contains = new boolean[128];
    public static final Map<Character, String> ESCAPE_REPLACEMENTS;
    public static final Map<Character, Integer> ESCAPE_CODES;

    private CharConstants(String string) {
        Arrays.fill(this.contains, false);
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            this.contains[n] = true;
        }
    }

    public boolean has(int n) {
        return n < 128 && this.contains[n];
    }

    public boolean hasNo(int n) {
        return !this.has(n);
    }

    public boolean has(int n, String string) {
        return this.has(n) || string.indexOf(n) != -1;
    }

    public boolean hasNo(int n, String string) {
        return !this.has(n, string);
    }

    public static String escapeChar(String string) {
        for (Character c : ESCAPE_REPLACEMENTS.keySet()) {
            String string2 = ESCAPE_REPLACEMENTS.get(c);
            if (" ".equals(string2) || "/".equals(string2) || "\"".equals(string2) || !string2.equals(string)) continue;
            return "\\" + c;
        }
        return string;
    }

    static {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        hashMap.put(Character.valueOf('0'), "\u0000");
        hashMap.put(Character.valueOf('a'), "\u0007");
        hashMap.put(Character.valueOf('b'), "\b");
        hashMap.put(Character.valueOf('t'), "\t");
        hashMap.put(Character.valueOf('n'), LINEBR_S);
        hashMap.put(Character.valueOf('v'), "\u000b");
        hashMap.put(Character.valueOf('f'), "\f");
        hashMap.put(Character.valueOf('r'), "\r");
        hashMap.put(Character.valueOf('e'), "\u001b");
        hashMap.put(Character.valueOf(' '), " ");
        hashMap.put(Character.valueOf('\"'), "\"");
        hashMap.put(Character.valueOf('/'), "/");
        hashMap.put(Character.valueOf('\\'), "\\");
        hashMap.put(Character.valueOf('N'), "\u0085");
        hashMap.put(Character.valueOf('_'), "\u00a0");
        ESCAPE_REPLACEMENTS = Collections.unmodifiableMap(hashMap);
        HashMap<Character, Integer> hashMap2 = new HashMap<Character, Integer>();
        hashMap2.put(Character.valueOf('x'), 2);
        hashMap2.put(Character.valueOf('u'), 4);
        hashMap2.put(Character.valueOf('U'), 8);
        ESCAPE_CODES = Collections.unmodifiableMap(hashMap2);
    }
}

