/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.composer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentEventsCollector;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.Anchor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.AliasEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.Event;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.MappingStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.NodeEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.ScalarEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.SequenceStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.ComposerException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.parser.Parser;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;

public class Composer
implements Iterator<Node> {
    protected final Parser parser;
    private final ScalarResolver scalarResolver;
    private final Map<Anchor, Node> anchors;
    private final Set<Node> recursiveNodes;
    private final LoadSettings settings;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;
    private int nonScalarAliasesCount = 0;

    @Deprecated
    public Composer(Parser parser, LoadSettings loadSettings) {
        this(loadSettings, parser);
    }

    public Composer(LoadSettings loadSettings, Parser parser) {
        this.parser = parser;
        this.scalarResolver = loadSettings.getSchema().getScalarResolver();
        this.settings = loadSettings;
        this.anchors = new HashMap<Anchor, Node>();
        this.recursiveNodes = new HashSet<Node>();
        this.blockCommentsCollector = new CommentEventsCollector(parser, CommentType.BLANK_LINE, CommentType.BLOCK);
        this.inlineCommentsCollector = new CommentEventsCollector(parser, CommentType.IN_LINE);
    }

    @Override
    public boolean hasNext() {
        if (this.parser.checkEvent(Event.ID.StreamStart)) {
            this.parser.next();
        }
        return !this.parser.checkEvent(Event.ID.StreamEnd);
    }

    public Optional<Node> getSingleNode() {
        this.parser.next();
        Optional<Node> optional = Optional.empty();
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            optional = Optional.of(this.next());
        }
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            Event event = this.parser.next();
            Optional<Mark> optional2 = optional.flatMap(Node::getStartMark);
            throw new ComposerException("expected a single document in the stream", optional2, "but found another document", event.getStartMark());
        }
        this.parser.next();
        return optional;
    }

    @Override
    public Node next() {
        this.blockCommentsCollector.collectEvents();
        if (this.parser.checkEvent(Event.ID.StreamEnd)) {
            List<CommentLine> list = this.blockCommentsCollector.consume();
            Optional<Mark> optional = list.get(0).getStartMark();
            List<NodeTuple> list2 = Collections.emptyList();
            MappingNode mappingNode = new MappingNode(Tag.COMMENT, false, list2, FlowStyle.BLOCK, optional, Optional.empty());
            mappingNode.setBlockComments(list);
            return mappingNode;
        }
        this.parser.next();
        Node node = this.composeNode(Optional.empty());
        this.blockCommentsCollector.collectEvents();
        if (!this.blockCommentsCollector.isEmpty()) {
            node.setEndComments(this.blockCommentsCollector.consume());
        }
        this.parser.next();
        this.anchors.clear();
        this.recursiveNodes.clear();
        this.nonScalarAliasesCount = 0;
        return node;
    }

    private Node composeNode(Optional<Node> optional) {
        Node node;
        this.blockCommentsCollector.collectEvents();
        optional.ifPresent(this.recursiveNodes::add);
        if (this.parser.checkEvent(Event.ID.Alias)) {
            AliasEvent aliasEvent = (AliasEvent)this.parser.next();
            Anchor anchor = aliasEvent.getAlias();
            if (!this.anchors.containsKey(anchor)) {
                throw new ComposerException("found undefined alias " + anchor, aliasEvent.getStartMark());
            }
            node = this.anchors.get(anchor);
            if (node.getNodeType() != NodeType.SCALAR) {
                ++this.nonScalarAliasesCount;
                if (this.nonScalarAliasesCount > this.settings.getMaxAliasesForCollections()) {
                    throw new YamlEngineException("Number of aliases for non-scalar nodes exceeds the specified max=" + this.settings.getMaxAliasesForCollections());
                }
            }
            if (this.recursiveNodes.remove(node)) {
                node.setRecursive(true);
            }
            this.blockCommentsCollector.consume();
            this.inlineCommentsCollector.collectEvents().consume();
        } else {
            NodeEvent nodeEvent = (NodeEvent)this.parser.peekEvent();
            Optional<Anchor> optional2 = nodeEvent.getAnchor();
            node = this.parser.checkEvent(Event.ID.Scalar) ? this.composeScalarNode(optional2, this.blockCommentsCollector.consume()) : (this.parser.checkEvent(Event.ID.SequenceStart) ? this.composeSequenceNode(optional2) : this.composeMappingNode(optional2));
        }
        optional.ifPresent(this.recursiveNodes::remove);
        return node;
    }

    private void registerAnchor(Anchor anchor, Node node) {
        this.anchors.put(anchor, node);
        node.setAnchor(Optional.of(anchor));
    }

    protected Node composeScalarNode(Optional<Anchor> optional, List<CommentLine> list) {
        Tag tag;
        ScalarEvent scalarEvent = (ScalarEvent)this.parser.next();
        Optional<String> optional2 = scalarEvent.getTag();
        boolean bl = false;
        if (!optional2.isPresent() || optional2.get().equals("!")) {
            tag = this.scalarResolver.resolve(scalarEvent.getValue(), scalarEvent.getImplicit().canOmitTagInPlainScalar());
            bl = true;
        } else {
            tag = new Tag(optional2.get());
        }
        ScalarNode scalarNode = new ScalarNode(tag, bl, scalarEvent.getValue(), scalarEvent.getScalarStyle(), scalarEvent.getStartMark(), scalarEvent.getEndMark());
        optional.ifPresent(anchor -> this.registerAnchor((Anchor)anchor, scalarNode));
        scalarNode.setBlockComments(list);
        scalarNode.setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        return scalarNode;
    }

    protected SequenceNode composeSequenceNode(Optional<Anchor> optional) {
        Tag tag;
        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)this.parser.next();
        Optional<String> optional2 = sequenceStartEvent.getTag();
        boolean bl = false;
        if (!optional2.isPresent() || optional2.get().equals("!")) {
            tag = Tag.SEQ;
            bl = true;
        } else {
            tag = new Tag(optional2.get());
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        SequenceNode sequenceNode = new SequenceNode(tag, bl, arrayList, sequenceStartEvent.getFlowStyle(), sequenceStartEvent.getStartMark(), Optional.empty());
        if (sequenceStartEvent.isFlow()) {
            sequenceNode.setBlockComments(this.blockCommentsCollector.consume());
        }
        optional.ifPresent(anchor -> this.registerAnchor((Anchor)anchor, sequenceNode));
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.SequenceEnd)) break;
            arrayList.add(this.composeNode(Optional.of(sequenceNode)));
        }
        if (sequenceStartEvent.isFlow()) {
            sequenceNode.setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        Event event = this.parser.next();
        sequenceNode.setEndMark(event.getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            sequenceNode.setInLineComments(this.inlineCommentsCollector.consume());
        }
        return sequenceNode;
    }

    protected Node composeMappingNode(Optional<Anchor> optional) {
        Tag tag;
        MappingStartEvent mappingStartEvent = (MappingStartEvent)this.parser.next();
        Optional<String> optional2 = mappingStartEvent.getTag();
        boolean bl = false;
        if (!optional2.isPresent() || optional2.get().equals("!")) {
            tag = Tag.MAP;
            bl = true;
        } else {
            tag = new Tag(optional2.get());
        }
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>();
        MappingNode mappingNode = new MappingNode(tag, bl, arrayList, mappingStartEvent.getFlowStyle(), mappingStartEvent.getStartMark(), Optional.empty());
        if (mappingStartEvent.isFlow()) {
            mappingNode.setBlockComments(this.blockCommentsCollector.consume());
        }
        optional.ifPresent(anchor -> this.registerAnchor((Anchor)anchor, mappingNode));
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            this.blockCommentsCollector.collectEvents();
            if (this.parser.checkEvent(Event.ID.MappingEnd)) break;
            this.composeMappingChildren(arrayList, mappingNode);
        }
        if (mappingStartEvent.isFlow()) {
            mappingNode.setInLineComments(this.inlineCommentsCollector.collectEvents().consume());
        }
        Event event = this.parser.next();
        mappingNode.setEndMark(event.getEndMark());
        this.inlineCommentsCollector.collectEvents();
        if (!this.inlineCommentsCollector.isEmpty()) {
            mappingNode.setInLineComments(this.inlineCommentsCollector.consume());
        }
        return mappingNode;
    }

    protected void composeMappingChildren(List<NodeTuple> list, MappingNode mappingNode) {
        Node node = this.composeKeyNode(mappingNode);
        Node node2 = this.composeValueNode(mappingNode);
        list.add(new NodeTuple(node, node2));
    }

    protected Node composeKeyNode(MappingNode mappingNode) {
        return this.composeNode(Optional.of(mappingNode));
    }

    protected Node composeValueNode(MappingNode mappingNode) {
        return this.composeNode(Optional.of(mappingNode));
    }
}

