/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.constructor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.ConstructorException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;

public abstract class BaseConstructor {
    protected final Map<Tag, ConstructNode> tagConstructors;
    final Map<Node, Object> constructedObjects;
    private final Set<Node> recursiveObjects;
    private final ArrayList<RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>> maps2fill;
    private final ArrayList<RecursiveTuple<Set<Object>, Object>> sets2fill;
    protected LoadSettings settings;

    public BaseConstructor(LoadSettings loadSettings) {
        this.settings = loadSettings;
        this.tagConstructors = new HashMap<Tag, ConstructNode>();
        this.constructedObjects = new HashMap<Node, Object>();
        this.recursiveObjects = new HashSet<Node>();
        this.maps2fill = new ArrayList();
        this.sets2fill = new ArrayList();
    }

    public Object constructSingleDocument(Optional<Node> optional) {
        if (!optional.isPresent() || Tag.NULL.equals(optional.get().getTag())) {
            ConstructNode constructNode = this.tagConstructors.get(Tag.NULL);
            return constructNode.construct(optional.orElse(null));
        }
        return this.construct(optional.get());
    }

    protected Object construct(Node node) {
        try {
            Object object = this.constructObject(node);
            this.fillRecursive();
            Object object2 = object;
            return object2;
        }
        catch (YamlEngineException yamlEngineException) {
            throw yamlEngineException;
        }
        catch (RuntimeException runtimeException) {
            throw new YamlEngineException(runtimeException);
        }
        finally {
            this.constructedObjects.clear();
            this.recursiveObjects.clear();
        }
    }

    private void fillRecursive() {
        if (!this.maps2fill.isEmpty()) {
            for (RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>> recursiveTuple : this.maps2fill) {
                RecursiveTuple<Object, Object> recursiveTuple2 = recursiveTuple.getValue2();
                recursiveTuple.getValue1().put(recursiveTuple2.getValue1(), recursiveTuple2.getValue2());
            }
            this.maps2fill.clear();
        }
        if (!this.sets2fill.isEmpty()) {
            for (RecursiveTuple<Object, Object> recursiveTuple : this.sets2fill) {
                ((Set)recursiveTuple.getValue1()).add(recursiveTuple.getValue2());
            }
            this.sets2fill.clear();
        }
    }

    protected Object constructObject(Node node) {
        Objects.requireNonNull(node, "Node cannot be null");
        if (this.constructedObjects.containsKey(node)) {
            return this.constructedObjects.get(node);
        }
        return this.constructObjectNoCheck(node);
    }

    protected Object constructObjectNoCheck(Node node) {
        if (this.recursiveObjects.contains(node)) {
            throw new ConstructorException(null, Optional.empty(), "found unconstructable recursive node", node.getStartMark());
        }
        this.recursiveObjects.add(node);
        ConstructNode constructNode = this.findConstructorFor(node).orElseThrow(() -> new ConstructorException(null, Optional.empty(), "could not determine a constructor for the tag " + node.getTag(), node.getStartMark()));
        Object object = this.constructedObjects.containsKey(node) ? this.constructedObjects.get(node) : constructNode.construct(node);
        this.constructedObjects.put(node, object);
        this.recursiveObjects.remove(node);
        if (node.isRecursive()) {
            constructNode.constructRecursive(node, object);
        }
        return object;
    }

    protected Optional<ConstructNode> findConstructorFor(Node node) {
        Tag tag = node.getTag();
        if (this.settings.getTagConstructors().containsKey(tag)) {
            return Optional.of(this.settings.getTagConstructors().get(tag));
        }
        if (this.tagConstructors.containsKey(tag)) {
            return Optional.of(this.tagConstructors.get(tag));
        }
        return Optional.empty();
    }

    protected String constructScalar(ScalarNode scalarNode) {
        return scalarNode.getValue();
    }

    protected List<Object> createEmptyListForNode(SequenceNode sequenceNode) {
        return this.settings.getDefaultList().apply(sequenceNode.getValue().size());
    }

    protected Set<Object> createEmptySetForNode(MappingNode mappingNode) {
        return this.settings.getDefaultSet().apply(mappingNode.getValue().size());
    }

    protected Map<Object, Object> createEmptyMapFor(MappingNode mappingNode) {
        return this.settings.getDefaultMap().apply(mappingNode.getValue().size());
    }

    protected List<Object> constructSequence(SequenceNode sequenceNode) {
        List<Object> list = this.settings.getDefaultList().apply(sequenceNode.getValue().size());
        this.constructSequenceStep2(sequenceNode, list);
        return list;
    }

    protected void constructSequenceStep2(SequenceNode sequenceNode, Collection<Object> collection) {
        for (Node node : sequenceNode.getValue()) {
            collection.add(this.constructObject(node));
        }
    }

    protected Set<Object> constructSet(MappingNode mappingNode) {
        Set<Object> set = this.settings.getDefaultSet().apply(mappingNode.getValue().size());
        this.constructSet2ndStep(mappingNode, set);
        return set;
    }

    protected Map<Object, Object> constructMapping(MappingNode mappingNode) {
        Map<Object, Object> map = this.settings.getDefaultMap().apply(mappingNode.getValue().size());
        this.constructMapping2ndStep(mappingNode, map);
        return map;
    }

    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        List<NodeTuple> list = mappingNode.getValue();
        for (NodeTuple nodeTuple : list) {
            Node node = nodeTuple.getKeyNode();
            Node node2 = nodeTuple.getValueNode();
            Object object = this.constructObject(node);
            if (object != null) {
                try {
                    object.hashCode();
                }
                catch (Exception exception) {
                    throw new ConstructorException("while constructing a mapping", mappingNode.getStartMark(), "found unacceptable key " + object, nodeTuple.getKeyNode().getStartMark(), exception);
                }
            }
            Object object2 = this.constructObject(node2);
            if (node.isRecursive()) {
                if (this.settings.getAllowRecursiveKeys()) {
                    this.postponeMapFilling(map, object, object2);
                    continue;
                }
                throw new YamlEngineException("Recursive key for mapping is detected but it is not configured to be allowed.");
            }
            map.put(object, object2);
        }
    }

    protected void postponeMapFilling(Map<Object, Object> map, Object object, Object object2) {
        this.maps2fill.add(0, new RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>(map, new RecursiveTuple<Object, Object>(object, object2)));
    }

    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        List<NodeTuple> list = mappingNode.getValue();
        for (NodeTuple nodeTuple : list) {
            Node node = nodeTuple.getKeyNode();
            Object object = this.constructObject(node);
            if (object != null) {
                try {
                    object.hashCode();
                }
                catch (Exception exception) {
                    throw new ConstructorException("while constructing a Set", mappingNode.getStartMark(), "found unacceptable key " + object, nodeTuple.getKeyNode().getStartMark(), exception);
                }
            }
            if (node.isRecursive()) {
                if (this.settings.getAllowRecursiveKeys()) {
                    this.postponeSetFilling(set, object);
                    continue;
                }
                throw new YamlEngineException("Recursive key for mapping is detected but it is not configured to be allowed.");
            }
            set.add(object);
        }
    }

    protected void postponeSetFilling(Set<Object> set, Object object) {
        this.sets2fill.add(0, new RecursiveTuple<Set<Object>, Object>(set, object));
    }

    private static class RecursiveTuple<T, K> {
        private final T value1;
        private final K value2;

        public RecursiveTuple(T t, K k) {
            this.value1 = t;
            this.value2 = k;
        }

        public K getValue2() {
            return this.value2;
        }

        public T getValue1() {
            return this.value1;
        }
    }
}

