/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.constructor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.constructor.BaseConstructor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.constructor.ConstructScalar;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.env.EnvConfig;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.ConstructorException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.DuplicateKeyException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.MissingEnvironmentVariableException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.resolver.JsonScalarResolver;

public class StandardConstructor
extends BaseConstructor {
    public StandardConstructor(LoadSettings loadSettings) {
        super(loadSettings);
        this.tagConstructors.put(Tag.SET, new ConstructYamlSet());
        this.tagConstructors.put(Tag.STR, new ConstructYamlStr());
        this.tagConstructors.put(Tag.SEQ, new ConstructYamlSeq());
        this.tagConstructors.put(Tag.MAP, new ConstructYamlMap());
        this.tagConstructors.put(Tag.ENV_TAG, new ConstructEnv());
        this.tagConstructors.putAll(loadSettings.getSchema().getSchemaTagConstructors());
        this.tagConstructors.putAll(loadSettings.getTagConstructors());
    }

    protected void flattenMapping(MappingNode mappingNode) {
        this.processDuplicateKeys(mappingNode);
    }

    protected void processDuplicateKeys(MappingNode mappingNode) {
        List<NodeTuple> list = mappingNode.getValue();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(list.size());
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        for (NodeTuple nodeTuple : list) {
            Node node = nodeTuple.getKeyNode();
            Object object = this.constructKey(node, mappingNode.getStartMark(), nodeTuple.getKeyNode().getStartMark());
            Integer n2 = hashMap.put(object, n);
            if (n2 != null) {
                if (!this.settings.getAllowDuplicateKeys()) {
                    throw new DuplicateKeyException(mappingNode.getStartMark(), object, nodeTuple.getKeyNode().getStartMark());
                }
                treeSet.add(n2);
            }
            ++n;
        }
        Iterator<NodeTuple> iterator = treeSet.descendingIterator();
        while (iterator.hasNext()) {
            list.remove((Integer)((Object)iterator.next()));
        }
    }

    private Object constructKey(Node node, Optional<Mark> optional, Optional<Mark> optional2) {
        Object object = this.constructObject(node);
        if (object != null) {
            try {
                object.hashCode();
            }
            catch (Exception exception) {
                throw new ConstructorException("while constructing a mapping", optional, "found unacceptable key " + object, optional2, exception);
            }
        }
        return object;
    }

    @Override
    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        this.flattenMapping(mappingNode);
        super.constructMapping2ndStep(mappingNode, map);
    }

    @Override
    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        this.flattenMapping(mappingNode);
        super.constructSet2ndStep(mappingNode, set);
    }

    public class ConstructYamlSet
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node.isRecursive()) {
                return StandardConstructor.this.constructedObjects.containsKey(node) ? StandardConstructor.this.constructedObjects.get(node) : StandardConstructor.this.createEmptySetForNode((MappingNode)node);
            }
            return StandardConstructor.this.constructSet((MappingNode)node);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive set structure. Node: " + node);
            }
            StandardConstructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
        }
    }

    public class ConstructYamlStr
    extends ConstructScalar {
        @Override
        public Object construct(Node node) {
            return this.constructScalar(node);
        }
    }

    public class ConstructYamlSeq
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            SequenceNode sequenceNode = (SequenceNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.createEmptyListForNode(sequenceNode);
            }
            return StandardConstructor.this.constructSequence(sequenceNode);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
            }
            StandardConstructor.this.constructSequenceStep2((SequenceNode)node, (List)object);
        }
    }

    public class ConstructYamlMap
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            MappingNode mappingNode = (MappingNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.createEmptyMapFor(mappingNode);
            }
            return StandardConstructor.this.constructMapping(mappingNode);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive mapping structure. Node: " + node);
            }
            StandardConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
        }
    }

    public class ConstructEnv
    extends ConstructScalar {
        @Override
        public Object construct(Node node) {
            String string = this.constructScalar(node);
            Optional<EnvConfig> optional = StandardConstructor.this.settings.getEnvConfig();
            if (optional.isPresent()) {
                EnvConfig envConfig = optional.get();
                Matcher matcher = JsonScalarResolver.ENV_FORMAT.matcher(string);
                matcher.matches();
                String string2 = matcher.group(1);
                String string3 = matcher.group(3);
                String string4 = string3 != null ? string3 : "";
                String string5 = matcher.group(2);
                String string6 = this.getEnv(string2);
                Optional<String> optional2 = envConfig.getValueFor(string2, string5, string4, string6);
                return optional2.orElseGet(() -> this.apply(string2, string5, string4, string6));
            }
            return string;
        }

        public String apply(String string, String string2, String string3, String string4) {
            if (string4 != null && !string4.isEmpty()) {
                return string4;
            }
            if (string2 != null) {
                if (string2.equals("?") && string4 == null) {
                    throw new MissingEnvironmentVariableException("Missing mandatory variable " + string + ": " + string3);
                }
                if (string2.equals(":?")) {
                    if (string4 == null) {
                        throw new MissingEnvironmentVariableException("Missing mandatory variable " + string + ": " + string3);
                    }
                    if (string4.isEmpty()) {
                        throw new MissingEnvironmentVariableException("Empty mandatory variable " + string + ": " + string3);
                    }
                }
                if (string2.startsWith(":") ? string4 == null || string4.isEmpty() : string4 == null) {
                    return string3;
                }
            }
            return "";
        }

        public String getEnv(String string) {
            return System.getenv(string);
        }
    }
}

