/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.emitter;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeSet;
import java.util.regex.Pattern;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.StreamDataWriter;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentEventsCollector;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.Anchor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ArrayStack;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.CharConstants;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.emitter.Emitable;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.emitter.EmitterState;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.emitter.ScalarAnalysis;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.AliasEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.CollectionEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.CollectionStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.CommentEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.DocumentEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.DocumentStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.Event;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.MappingStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.NodeEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.ScalarEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.SequenceStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.StreamEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.StreamStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.EmitterException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner.StreamReader;

public final class Emitter
implements Emitable {
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    public static final int MIN_INDENT = 1;
    public static final int MAX_INDENT = 10;
    private static final String SPACE = " ";
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    private final StreamDataWriter stream;
    private final ArrayStack<EmitterState> states;
    private EmitterState state;
    private final Queue<Event> events;
    private Event event;
    private final ArrayStack<Integer> indents;
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private final Boolean canonical;
    private final Boolean multiLineFlow;
    private final boolean allowUnicode;
    private int bestIndent;
    private final int indicatorIndent;
    private final boolean indentWithIndicator;
    private int bestWidth;
    private final String bestLineBreak;
    private final boolean splitLines;
    private final int maxSimpleKeyLength;
    private final boolean emitComments;
    private Map<String, String> tagPrefixes;
    private Optional<Anchor> preparedAnchor;
    private String preparedTag;
    private ScalarAnalysis analysis;
    private ScalarStyle scalarStyle;
    private final CommentEventsCollector blockCommentsCollector;
    private final CommentEventsCollector inlineCommentsCollector;
    private static final Pattern HANDLE_FORMAT;

    public Emitter(DumpSettings dumpSettings, StreamDataWriter streamDataWriter) {
        this.stream = streamDataWriter;
        this.states = new ArrayStack(100);
        this.state = new ExpectStreamStart();
        this.events = new ArrayDeque<Event>(100);
        this.event = null;
        this.indents = new ArrayStack(10);
        this.indent = null;
        this.flowLevel = 0;
        this.mappingContext = false;
        this.simpleKeyContext = false;
        this.column = 0;
        this.whitespace = true;
        this.indention = true;
        this.openEnded = false;
        this.canonical = dumpSettings.isCanonical();
        this.multiLineFlow = dumpSettings.isMultiLineFlow();
        this.allowUnicode = dumpSettings.isUseUnicodeEncoding();
        this.bestIndent = 2;
        if (dumpSettings.getIndent() > 1 && dumpSettings.getIndent() < 10) {
            this.bestIndent = dumpSettings.getIndent();
        }
        this.indicatorIndent = dumpSettings.getIndicatorIndent();
        this.indentWithIndicator = dumpSettings.getIndentWithIndicator();
        this.bestWidth = 80;
        if (dumpSettings.getWidth() > this.bestIndent * 2) {
            this.bestWidth = dumpSettings.getWidth();
        }
        this.bestLineBreak = dumpSettings.getBestLineBreak();
        this.splitLines = dumpSettings.isSplitLines();
        this.maxSimpleKeyLength = dumpSettings.getMaxSimpleKeyLength();
        this.emitComments = dumpSettings.getDumpComments();
        this.tagPrefixes = new LinkedHashMap<String, String>();
        this.preparedAnchor = Optional.empty();
        this.preparedTag = null;
        this.analysis = null;
        this.scalarStyle = null;
        this.blockCommentsCollector = new CommentEventsCollector(this.events, CommentType.BLANK_LINE, CommentType.BLOCK);
        this.inlineCommentsCollector = new CommentEventsCollector(this.events, CommentType.IN_LINE);
    }

    @Override
    public void emit(Event event) {
        this.events.add(event);
        while (!this.needMoreEvents()) {
            this.event = this.events.poll();
            this.state.expect();
            this.event = null;
        }
    }

    private boolean needMoreEvents() {
        if (this.events.isEmpty()) {
            return true;
        }
        Iterator<Event> iterator = this.events.iterator();
        Event event = (Event)iterator.next();
        while (event instanceof CommentEvent) {
            if (!iterator.hasNext()) {
                return true;
            }
            event = (Event)iterator.next();
        }
        if (event instanceof DocumentStartEvent) {
            return this.needEvents(iterator, 1);
        }
        if (event instanceof SequenceStartEvent) {
            return this.needEvents(iterator, 2);
        }
        if (event instanceof MappingStartEvent) {
            return this.needEvents(iterator, 3);
        }
        if (event instanceof StreamStartEvent) {
            return this.needEvents(iterator, 2);
        }
        if (event instanceof StreamEndEvent) {
            return false;
        }
        if (this.emitComments) {
            return this.needEvents(iterator, 1);
        }
        return false;
    }

    private boolean needEvents(Iterator<Event> iterator, int n) {
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            Event event = iterator.next();
            if (event instanceof CommentEvent) continue;
            ++n3;
            if (event instanceof DocumentStartEvent || event instanceof CollectionStartEvent) {
                ++n2;
            } else if (event instanceof DocumentEndEvent || event instanceof CollectionEndEvent) {
                --n2;
            } else if (event instanceof StreamEndEvent) {
                n2 = -1;
            }
            if (n2 >= 0) continue;
            return false;
        }
        return n3 < n;
    }

    private void increaseIndent(boolean bl, boolean bl2) {
        this.indents.push(this.indent);
        if (this.indent == null) {
            this.indent = bl ? Integer.valueOf(this.bestIndent) : Integer.valueOf(0);
        } else if (!bl2) {
            this.indent = this.indent + this.bestIndent;
        }
    }

    private void expectNode(boolean bl, boolean bl2, boolean bl3) {
        this.rootContext = bl;
        this.mappingContext = bl2;
        this.simpleKeyContext = bl3;
        if (this.event.getEventId() == Event.ID.Alias) {
            this.expectAlias();
        } else if (this.event.getEventId() == Event.ID.Scalar || this.event.getEventId() == Event.ID.SequenceStart || this.event.getEventId() == Event.ID.MappingStart) {
            this.processAnchor("&");
            this.processTag();
            this.handleNodeEvent(this.event.getEventId());
        } else {
            throw new EmitterException("expected NodeEvent, but got " + (Object)((Object)this.event.getEventId()));
        }
    }

    private void handleNodeEvent(Event.ID iD) {
        switch (iD) {
            case Scalar: {
                this.expectScalar();
                break;
            }
            case SequenceStart: {
                if (this.flowLevel != 0 || this.canonical.booleanValue() || ((SequenceStartEvent)this.event).isFlow() || this.checkEmptySequence()) {
                    this.expectFlowSequence();
                    break;
                }
                this.expectBlockSequence();
                break;
            }
            case MappingStart: {
                if (this.flowLevel != 0 || this.canonical.booleanValue() || ((MappingStartEvent)this.event).isFlow() || this.checkEmptyMapping()) {
                    this.expectFlowMapping();
                    break;
                }
                this.expectBlockMapping();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void expectAlias() {
        if (!(this.event instanceof AliasEvent)) {
            throw new EmitterException("Expecting Alias.");
        }
        this.processAnchor("*");
        this.state = this.states.pop();
    }

    private void expectScalar() {
        this.increaseIndent(true, false);
        this.processScalar();
        this.indent = this.indents.pop();
        this.state = this.states.pop();
    }

    private void expectFlowSequence() {
        this.writeIndicator("[", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        if (this.multiLineFlow.booleanValue()) {
            this.writeIndent();
        }
        this.state = new ExpectFirstFlowSequenceItem();
    }

    private void expectFlowMapping() {
        this.writeIndicator("{", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        if (this.multiLineFlow.booleanValue()) {
            this.writeIndent();
        }
        this.state = new ExpectFirstFlowMappingKey();
    }

    private void expectBlockSequence() {
        boolean bl = this.mappingContext && !this.indention;
        this.increaseIndent(false, bl);
        this.state = new ExpectFirstBlockSequenceItem();
    }

    private void expectBlockMapping() {
        this.increaseIndent(false, false);
        this.state = new ExpectFirstBlockMappingKey();
    }

    private boolean isFoldedOrLiteral(Event event) {
        if (event.getEventId() != Event.ID.Scalar) {
            return false;
        }
        ScalarEvent scalarEvent = (ScalarEvent)event;
        ScalarStyle scalarStyle = scalarEvent.getScalarStyle();
        return scalarStyle == ScalarStyle.FOLDED || scalarStyle == ScalarStyle.LITERAL;
    }

    private boolean checkEmptySequence() {
        return this.event.getEventId() == Event.ID.SequenceStart && !this.events.isEmpty() && this.events.peek().getEventId() == Event.ID.SequenceEnd;
    }

    private boolean checkEmptyMapping() {
        return this.event.getEventId() == Event.ID.MappingStart && !this.events.isEmpty() && this.events.peek().getEventId() == Event.ID.MappingEnd;
    }

    private boolean checkSimpleKey() {
        Optional<Object> optional;
        int n = 0;
        if (this.event instanceof NodeEvent && (optional = ((NodeEvent)this.event).getAnchor()).isPresent()) {
            if (!this.preparedAnchor.isPresent()) {
                this.preparedAnchor = optional;
            }
            n += ((Anchor)optional.get()).getValue().length();
        }
        optional = Optional.empty();
        if (this.event.getEventId() == Event.ID.Scalar) {
            optional = ((ScalarEvent)this.event).getTag();
        } else if (this.event instanceof CollectionStartEvent) {
            optional = ((CollectionStartEvent)this.event).getTag();
        }
        if (optional.isPresent()) {
            if (this.preparedTag == null) {
                this.preparedTag = this.prepareTag((String)optional.get());
            }
            n += this.preparedTag.length();
        }
        if (this.event.getEventId() == Event.ID.Scalar) {
            if (this.analysis == null) {
                this.analysis = this.analyzeScalar(((ScalarEvent)this.event).getValue());
            }
            n += this.analysis.getScalar().length();
        }
        return n < this.maxSimpleKeyLength && (this.event.getEventId() == Event.ID.Alias || this.event.getEventId() == Event.ID.Scalar && !this.analysis.isEmpty() && !this.analysis.isMultiline() || this.checkEmptySequence() || this.checkEmptyMapping());
    }

    private void processAnchor(String string) {
        NodeEvent nodeEvent = (NodeEvent)this.event;
        Optional<Anchor> optional = nodeEvent.getAnchor();
        if (optional.isPresent()) {
            Anchor anchor = optional.get();
            if (!this.preparedAnchor.isPresent()) {
                this.preparedAnchor = optional;
            }
            this.writeIndicator(string + anchor, true, false, false);
        }
        this.preparedAnchor = Optional.empty();
    }

    private void processTag() {
        Optional<String> optional;
        if (this.event.getEventId() == Event.ID.Scalar) {
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            optional = scalarEvent.getTag();
            if (this.scalarStyle == null) {
                this.scalarStyle = this.chooseScalarStyle(scalarEvent);
            }
            if ((!this.canonical.booleanValue() || !optional.isPresent()) && (this.scalarStyle == ScalarStyle.PLAIN && scalarEvent.getImplicit().canOmitTagInPlainScalar() || this.scalarStyle != ScalarStyle.PLAIN && scalarEvent.getImplicit().canOmitTagInNonPlainScalar())) {
                this.preparedTag = null;
                return;
            }
            if (scalarEvent.getImplicit().canOmitTagInPlainScalar() && !optional.isPresent()) {
                optional = Optional.of("!");
                this.preparedTag = null;
            }
        } else {
            CollectionStartEvent collectionStartEvent = (CollectionStartEvent)this.event;
            optional = collectionStartEvent.getTag();
            if (!(this.canonical.booleanValue() && optional.isPresent() || !collectionStartEvent.isImplicit())) {
                this.preparedTag = null;
                return;
            }
        }
        if (!optional.isPresent()) {
            throw new EmitterException("tag is not specified");
        }
        if (this.preparedTag == null) {
            this.preparedTag = this.prepareTag(optional.get());
        }
        this.writeIndicator(this.preparedTag, true, false, false);
        this.preparedTag = null;
    }

    private ScalarStyle chooseScalarStyle(ScalarEvent scalarEvent) {
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (!scalarEvent.isPlain() && scalarEvent.isDQuoted() || this.canonical.booleanValue()) {
            return ScalarStyle.DOUBLE_QUOTED;
        }
        if (scalarEvent.isJson() && Optional.of(Tag.STR.getValue()).equals(scalarEvent.getTag())) {
            return ScalarStyle.DOUBLE_QUOTED;
        }
        if ((scalarEvent.isPlain() || scalarEvent.isJson()) && scalarEvent.getImplicit().canOmitTagInPlainScalar() && (!this.simpleKeyContext || !this.analysis.isEmpty() && !this.analysis.isMultiline()) && (this.flowLevel != 0 && this.analysis.isAllowFlowPlain() || this.flowLevel == 0 && this.analysis.isAllowBlockPlain())) {
            return ScalarStyle.PLAIN;
        }
        if ((scalarEvent.isLiteral() || scalarEvent.isFolded()) && this.flowLevel == 0 && !this.simpleKeyContext && this.analysis.isAllowBlock()) {
            return scalarEvent.getScalarStyle();
        }
        if (!(!scalarEvent.isPlain() && !scalarEvent.isSQuoted() || !this.analysis.isAllowSingleQuoted() || this.simpleKeyContext && this.analysis.isMultiline())) {
            return ScalarStyle.SINGLE_QUOTED;
        }
        return ScalarStyle.DOUBLE_QUOTED;
    }

    private void processScalar() {
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        boolean bl = !this.simpleKeyContext && this.splitLines;
        switch (this.scalarStyle) {
            case PLAIN: {
                this.writePlain(this.analysis.getScalar(), bl);
                break;
            }
            case DOUBLE_QUOTED: {
                this.writeDoubleQuoted(this.analysis.getScalar(), bl);
                break;
            }
            case SINGLE_QUOTED: {
                this.writeSingleQuoted(this.analysis.getScalar(), bl);
                break;
            }
            case FOLDED: {
                this.writeFolded(this.analysis.getScalar(), bl);
                break;
            }
            case LITERAL: {
                this.writeLiteral(this.analysis.getScalar());
                break;
            }
            default: {
                throw new YamlEngineException("Unexpected scalarStyle: " + (Object)((Object)this.scalarStyle));
            }
        }
        this.analysis = null;
        this.scalarStyle = null;
    }

    private String prepareVersion(SpecVersion specVersion) {
        if (specVersion.getMajor() != 1) {
            throw new EmitterException("unsupported YAML version: " + specVersion);
        }
        return specVersion.getRepresentation();
    }

    private String prepareTagHandle(String string) {
        if (string.isEmpty()) {
            throw new EmitterException("tag handle must not be empty");
        }
        if (string.charAt(0) != '!' || string.charAt(string.length() - 1) != '!') {
            throw new EmitterException("tag handle must start and end with '!': " + string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid character in the tag handle: " + string);
        }
        return string;
    }

    private String prepareTagPrefix(String string) {
        if (string.isEmpty()) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (string.charAt(0) == '!') {
            n = 1;
        }
        while (n < string.length()) {
            ++n;
        }
        stringBuilder.append(string, 0, n);
        return stringBuilder.toString();
    }

    private String prepareTag(String string) {
        if (string.isEmpty()) {
            throw new EmitterException("tag must not be empty");
        }
        if ("!".equals(string)) {
            return string;
        }
        String string2 = null;
        String string3 = string;
        for (String string4 : this.tagPrefixes.keySet()) {
            if (!string.startsWith(string4) || !"!".equals(string4) && string4.length() >= string.length()) continue;
            string2 = string4;
        }
        if (string2 != null) {
            string3 = string.substring(string2.length());
            string2 = this.tagPrefixes.get(string2);
        }
        if (string2 != null) {
            return string2 + string3;
        }
        return "!<" + string3 + ">";
    }

    private ScalarAnalysis analyzeScalar(String string) {
        int n;
        int n2;
        int n3;
        if (string.isEmpty()) {
            return new ScalarAnalysis(string, true, false, false, true, true, false);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        if (string.startsWith("---") || string.startsWith("...")) {
            bl = true;
            bl2 = true;
        }
        boolean bl11 = true;
        boolean bl12 = string.length() == 1 || CharConstants.NULL_BL_T_LINEBR.has(string.codePointAt(1));
        boolean bl13 = false;
        boolean bl14 = false;
        int n4 = 0;
        while (n4 < string.length()) {
            n3 = string.codePointAt(n4);
            if (n4 == 0) {
                if ("#,[]{}&*!|>'\"%@`".indexOf(n3) != -1) {
                    bl2 = true;
                    bl = true;
                }
                if (n3 == 63 || n3 == 58) {
                    bl2 = true;
                    if (bl12) {
                        bl = true;
                    }
                }
                if (n3 == 45 && bl12) {
                    bl2 = true;
                    bl = true;
                }
            } else {
                if (",?[]{}".indexOf(n3) != -1) {
                    bl2 = true;
                }
                if (n3 == 58) {
                    bl2 = true;
                    if (bl12) {
                        bl = true;
                    }
                }
                if (n3 == 35 && bl11) {
                    bl2 = true;
                    bl = true;
                }
            }
            if ((n2 = (int)(CharConstants.LINEBR.has(n3) ? 1 : 0)) != 0) {
                bl3 = true;
            }
            if (n3 != 10 && (32 > n3 || n3 > 126)) {
                if (n3 == 133 || n3 >= 160 && n3 <= 55295 || n3 >= 57344 && n3 <= 65533 || n3 >= 65536 && n3 <= 0x10FFFF) {
                    if (!this.allowUnicode) {
                        bl4 = true;
                    }
                } else {
                    bl4 = true;
                }
            }
            if (n3 == 32) {
                if (n4 == 0) {
                    bl5 = true;
                }
                if (n4 == string.length() - 1) {
                    bl7 = true;
                }
                if (bl14) {
                    bl9 = true;
                }
                bl13 = true;
                bl14 = false;
            } else if (n2 != 0) {
                if (n4 == 0) {
                    bl6 = true;
                }
                if (n4 == string.length() - 1) {
                    bl8 = true;
                }
                if (bl13) {
                    bl10 = true;
                }
                bl13 = false;
                bl14 = true;
            } else {
                bl13 = false;
                bl14 = false;
            }
            bl11 = CharConstants.NULL_BL_T.has(n3) || n2 != 0;
            bl12 = true;
            if ((n4 += Character.charCount(n3)) + 1 >= string.length() || (n = n4 + Character.charCount(string.codePointAt(n4))) >= string.length()) continue;
            bl12 = CharConstants.NULL_BL_T.has(string.codePointAt(n)) || n2 != 0;
        }
        n3 = 1;
        n2 = 1;
        n = 1;
        int n5 = 1;
        if (bl5 || bl6 || bl7 || bl8) {
            n2 = 0;
            n3 = 0;
        }
        if (bl7) {
            n5 = 0;
        }
        if (bl9) {
            n = 0;
            n2 = 0;
            n3 = 0;
        }
        if (bl10 || bl4) {
            n5 = 0;
            n = 0;
            n2 = 0;
            n3 = 0;
        }
        if (bl3) {
            n3 = 0;
        }
        if (bl2) {
            n3 = 0;
        }
        if (bl) {
            n2 = 0;
        }
        return new ScalarAnalysis(string, false, bl3, n3 != 0, n2 != 0, n != 0, n5 != 0);
    }

    void flushStream() {
        this.stream.flush();
    }

    void writeStreamStart() {
    }

    void writeStreamEnd() {
        this.flushStream();
    }

    void writeIndicator(String string, boolean bl, boolean bl2, boolean bl3) {
        if (!this.whitespace && bl) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = bl2;
        this.indention = this.indention && bl3;
        this.column += string.length();
        this.openEnded = false;
        this.stream.write(string);
    }

    int writeIndent() {
        int n = this.indent != null ? this.indent : 0;
        if (!this.indention || this.column > n || this.column == n && !this.whitespace) {
            this.writeLineBreak(null);
        }
        int n2 = n - this.column;
        this.writeWhitespace(n2);
        return n2;
    }

    private void writeWhitespace(int n) {
        if (n <= 0) {
            return;
        }
        this.whitespace = true;
        for (int i = 0; i < n; ++i) {
            this.stream.write(SPACE);
        }
        this.column += n;
    }

    private void writeLineBreak(String string) {
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        if (string == null) {
            this.stream.write(this.bestLineBreak);
        } else {
            this.stream.write(string);
        }
    }

    void writeVersionDirective(String string) {
        this.stream.write("%YAML ");
        this.stream.write(string);
        this.writeLineBreak(null);
    }

    void writeTagDirective(String string, String string2) {
        this.stream.write("%TAG ");
        this.stream.write(string);
        this.stream.write(SPACE);
        this.stream.write(string2);
        this.writeLineBreak(null);
    }

    private void writeSingleQuoted(String string, boolean bl) {
        this.writeIndicator("'", true, false, false);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            int n2;
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl2) {
                if (c != ' ') {
                    if (n + 1 == i && this.column > this.bestWidth && bl && n != 0 && i != string.length()) {
                        this.writeIndent();
                    } else {
                        n2 = i - n;
                        this.column += n2;
                        this.stream.write(string, n, n2);
                    }
                    n = i;
                }
            } else if (bl3) {
                if (c == '\u0000' || CharConstants.LINEBR.hasNo(c)) {
                    if (string.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String string2 = string.substring(n, i);
                    for (char c2 : string2.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    this.writeIndent();
                    n = i;
                }
            } else if (CharConstants.LINEBR.has(c, "\u0000 '") && n < i) {
                n2 = i - n;
                this.column += n2;
                this.stream.write(string, n, n2);
                n = i;
            }
            if (c == '\'') {
                this.column += 2;
                this.stream.write("''");
                n = i + 1;
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = CharConstants.LINEBR.has(c);
        }
        this.writeIndicator("'", false, false, false);
    }

    private void writeDoubleQuoted(String string, boolean bl) {
        this.writeIndicator("\"", true, false, false);
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            Character c = null;
            if (i < string.length()) {
                c = Character.valueOf(string.charAt(i));
            }
            if (c == null || "\"\\\u0085\u2028\u2029\ufeff".indexOf(c.charValue()) != -1 || ' ' > c.charValue() || c.charValue() > '~') {
                if (n < i) {
                    int n2 = i - n;
                    this.column += n2;
                    this.stream.write(string, n, n2);
                    n = i;
                }
                if (c != null) {
                    String string2;
                    if (ESCAPE_REPLACEMENTS.containsKey(c)) {
                        string2 = "\\" + ESCAPE_REPLACEMENTS.get(c);
                    } else {
                        int n3;
                        if (Character.isHighSurrogate(c.charValue()) && i + 1 < string.length()) {
                            char c2 = string.charAt(i + 1);
                            n3 = Character.toCodePoint(c.charValue(), c2);
                        } else {
                            n3 = c.charValue();
                        }
                        if (this.allowUnicode && StreamReader.isPrintable(n3)) {
                            string2 = String.valueOf(Character.toChars(n3));
                            if (Character.charCount(n3) == 2) {
                                ++i;
                            }
                        } else if (c.charValue() <= '\u00ff') {
                            String string3 = "0" + Integer.toString(c.charValue(), 16);
                            string2 = "\\x" + string3.substring(string3.length() - 2);
                        } else if (Character.charCount(n3) == 2) {
                            ++i;
                            String string4 = "000" + Long.toHexString(n3);
                            string2 = "\\U" + string4.substring(string4.length() - 8);
                        } else {
                            String string5 = "000" + Integer.toString(c.charValue(), 16);
                            string2 = "\\u" + string5.substring(string5.length() - 4);
                        }
                    }
                    this.column += string2.length();
                    this.stream.write(string2);
                    n = i + 1;
                }
            }
            if (0 >= i || i >= string.length() - 1 || c.charValue() != ' ' && n < i || this.column + (i - n) <= this.bestWidth || !bl) continue;
            String string6 = n >= i ? "\\" : string.substring(n, i) + "\\";
            if (n < i) {
                n = i;
            }
            this.column += string6.length();
            this.stream.write(string6);
            this.writeIndent();
            this.whitespace = false;
            this.indention = false;
            if (string.charAt(n) != ' ') continue;
            string6 = "\\";
            this.column += string6.length();
            this.stream.write(string6);
        }
        this.writeIndicator("\"", false, false, false);
    }

    private boolean writeCommentLines(List<CommentLine> list) {
        boolean bl = false;
        if (this.emitComments) {
            int n = 0;
            int n2 = 0;
            boolean bl2 = true;
            for (CommentLine commentLine : list) {
                if (commentLine.getCommentType() != CommentType.BLANK_LINE) {
                    if (bl2) {
                        bl2 = false;
                        this.writeIndicator("#", commentLine.getCommentType() == CommentType.IN_LINE, false, false);
                        n = this.column > 0 ? this.column - 1 : 0;
                    } else {
                        this.writeWhitespace(n - n2);
                        this.writeIndicator("#", false, false, false);
                    }
                    this.stream.write(commentLine.getValue());
                    this.writeLineBreak(null);
                    n2 = 0;
                } else {
                    this.writeLineBreak(null);
                    n2 = this.writeIndent();
                }
                bl = true;
            }
        }
        return bl;
    }

    private void writeBlockComment() {
        if (!this.blockCommentsCollector.isEmpty()) {
            this.writeIndent();
            this.writeCommentLines(this.blockCommentsCollector.consume());
        }
    }

    private boolean writeInlineComments() {
        return this.writeCommentLines(this.inlineCommentsCollector.consume());
    }

    private String determineBlockHints(String string) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        if (CharConstants.LINEBR.has(string.charAt(0), SPACE)) {
            stringBuilder.append(this.bestIndent);
        }
        if (CharConstants.LINEBR.hasNo(c = string.charAt(string.length() - 1))) {
            stringBuilder.append("-");
        } else if (string.length() == 1 || CharConstants.LINEBR.has(string.charAt(string.length() - 2))) {
            stringBuilder.append("+");
        }
        return stringBuilder.toString();
    }

    void writeFolded(String string, boolean bl) {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator(">" + string2, true, false, false);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '+') {
            this.openEnded = true;
        }
        if (!this.writeInlineComments()) {
            this.writeLineBreak(null);
        }
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = true;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl4) {
                if (c == '\u0000' || CharConstants.LINEBR.hasNo(c)) {
                    if (!bl2 && c != '\u0000' && c != ' ' && string.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl2 = c == ' ';
                    String string3 = string.substring(n, i);
                    for (char c2 : string3.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    if (c != '\u0000') {
                        this.writeIndent();
                    }
                    n = i;
                }
            } else if (bl3) {
                if (c != ' ') {
                    if (n + 1 == i && this.column > this.bestWidth && bl) {
                        this.writeIndent();
                    } else {
                        int n2 = i - n;
                        this.column += n2;
                        this.stream.write(string, n, n2);
                    }
                    n = i;
                }
            } else if (CharConstants.LINEBR.has(c, "\u0000 ")) {
                int n3 = i - n;
                this.column += n3;
                this.stream.write(string, n, n3);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = i;
            }
            if (c == '\u0000') continue;
            bl4 = CharConstants.LINEBR.has(c);
            bl3 = c == ' ';
        }
    }

    void writeLiteral(String string) {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator("|" + string2, true, false, false);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '+') {
            this.openEnded = true;
        }
        if (!this.writeInlineComments()) {
            this.writeLineBreak(null);
        }
        boolean bl = true;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl) {
                if (c == '\u0000' || CharConstants.LINEBR.hasNo(c)) {
                    String string3 = string.substring(n, i);
                    for (char c2 : string3.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    if (c != '\u0000') {
                        this.writeIndent();
                    }
                    n = i;
                }
            } else if (c == '\u0000' || CharConstants.LINEBR.has(c)) {
                this.stream.write(string, n, i - n);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = i;
            }
            if (c == '\u0000') continue;
            bl = CharConstants.LINEBR.has(c);
        }
    }

    void writePlain(String string, boolean bl) {
        if (this.rootContext) {
            this.openEnded = true;
        }
        if (string.isEmpty()) {
            return;
        }
        if (!this.whitespace) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = false;
        this.indention = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            int n2;
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl2) {
                if (c != ' ') {
                    if (n + 1 == i && this.column > this.bestWidth && bl) {
                        this.writeIndent();
                        this.whitespace = false;
                        this.indention = false;
                    } else {
                        n2 = i - n;
                        this.column += n2;
                        this.stream.write(string, n, n2);
                    }
                    n = i;
                }
            } else if (bl3) {
                if (CharConstants.LINEBR.hasNo(c)) {
                    if (string.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String string2 = string.substring(n, i);
                    for (char c2 : string2.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    this.writeIndent();
                    this.whitespace = false;
                    this.indention = false;
                    n = i;
                }
            } else if (CharConstants.LINEBR.has(c, "\u0000 ")) {
                n2 = i - n;
                this.column += n2;
                this.stream.write(string, n, n2);
                n = i;
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = CharConstants.LINEBR.has(c);
        }
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\b'), "b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\n'), "n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\f'), "f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\r'), "r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u00a0'), "_");
        DEFAULT_TAG_PREFIXES = new LinkedHashMap<String, String>();
        DEFAULT_TAG_PREFIXES.put("!", "!");
        DEFAULT_TAG_PREFIXES.put("tag:yaml.org,2002:", "!!");
        HANDLE_FORMAT = Pattern.compile("^![-_\\w]*!$");
    }

    private class ExpectStreamStart
    implements EmitterState {
        private ExpectStreamStart() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() != Event.ID.StreamStart) {
                throw new EmitterException("expected StreamStartEvent, but got " + Emitter.this.event);
            }
            Emitter.this.writeStreamStart();
            Emitter.this.state = new ExpectFirstDocumentStart();
        }
    }

    private class ExpectFirstFlowSequenceItem
    implements EmitterState {
        private ExpectFirstFlowSequenceItem() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                Emitter.this.writeIndicator("]", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeBlockComment();
            } else {
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.states.push(new ExpectFlowSequenceItem());
                Emitter.this.expectNode(false, false, false);
                Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeInlineComments();
            }
        }
    }

    private class ExpectFirstFlowMappingKey
    implements EmitterState {
        private ExpectFirstFlowMappingKey() {
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (Emitter.this.event.getEventId() == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                Emitter.this.writeIndicator("}", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                if (!Emitter.this.canonical.booleanValue() && Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.push(new ExpectFlowMappingSimpleValue());
                    Emitter.this.expectNode(false, true, true);
                } else {
                    Emitter.this.writeIndicator("?", true, false, false);
                    Emitter.this.states.push(new ExpectFlowMappingValue());
                    Emitter.this.expectNode(false, true, false);
                }
            }
        }
    }

    private class ExpectFirstBlockSequenceItem
    implements EmitterState {
        private ExpectFirstBlockSequenceItem() {
        }

        @Override
        public void expect() {
            new ExpectBlockSequenceItem(true).expect();
        }
    }

    private class ExpectFirstBlockMappingKey
    implements EmitterState {
        private ExpectFirstBlockMappingKey() {
        }

        @Override
        public void expect() {
            new ExpectBlockMappingKey(true).expect();
        }
    }

    private class ExpectBlockMappingValue
    implements EmitterState {
        private ExpectBlockMappingValue() {
        }

        @Override
        public void expect() {
            Emitter.this.writeIndent();
            Emitter.this.writeIndicator(":", true, false, true);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            Emitter.this.states.push(new ExpectBlockMappingKey(false));
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    private class ExpectBlockMappingSimpleValue
    implements EmitterState {
        private ExpectBlockMappingSimpleValue() {
        }

        @Override
        public void expect() {
            Emitter.this.writeIndicator(":", false, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.isFoldedOrLiteral(Emitter.this.event) && Emitter.this.writeInlineComments()) {
                Emitter.this.increaseIndent(true, false);
                Emitter.this.writeIndent();
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
            }
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.this.increaseIndent(true, false);
                Emitter.this.writeBlockComment();
                Emitter.this.writeIndent();
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
            }
            Emitter.this.states.push(new ExpectBlockMappingKey(false));
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents();
            Emitter.this.writeInlineComments();
        }
    }

    private class ExpectBlockMappingKey
    implements EmitterState {
        private final boolean first;

        public ExpectBlockMappingKey(boolean bl) {
            this.first = bl;
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (!this.first && Emitter.this.event.getEventId() == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                Emitter.this.writeIndent();
                if (Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.push(new ExpectBlockMappingSimpleValue());
                    Emitter.this.expectNode(false, true, true);
                } else {
                    Emitter.this.writeIndicator("?", true, false, true);
                    Emitter.this.states.push(new ExpectBlockMappingValue());
                    Emitter.this.expectNode(false, true, false);
                }
            }
        }
    }

    private class ExpectBlockSequenceItem
    implements EmitterState {
        private final boolean first;

        public ExpectBlockSequenceItem(boolean bl) {
            this.first = bl;
        }

        @Override
        public void expect() {
            if (!this.first && Emitter.this.event.getEventId() == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
            } else {
                Emitter.this.writeIndent();
                if (!Emitter.this.indentWithIndicator || this.first) {
                    Emitter.this.writeWhitespace(Emitter.this.indicatorIndent);
                }
                Emitter.this.writeIndicator("-", true, false, true);
                if (Emitter.this.indentWithIndicator && this.first) {
                    Emitter.this.indent = Emitter.this.indent + Emitter.this.indicatorIndent;
                }
                if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                    Emitter.this.increaseIndent(false, false);
                    Emitter.this.writeBlockComment();
                    if (Emitter.this.event instanceof ScalarEvent) {
                        Emitter.this.analysis = Emitter.this.analyzeScalar(((ScalarEvent)Emitter.this.event).getValue());
                        if (!Emitter.this.analysis.isEmpty()) {
                            Emitter.this.writeIndent();
                        }
                    }
                    Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                }
                Emitter.this.states.push(new ExpectBlockSequenceItem(false));
                Emitter.this.expectNode(false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
            }
        }
    }

    private class ExpectFlowMappingValue
    implements EmitterState {
        private ExpectFlowMappingValue() {
        }

        @Override
        public void expect() {
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth || Emitter.this.multiLineFlow.booleanValue()) {
                Emitter.this.writeIndent();
            }
            Emitter.this.writeIndicator(":", true, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.states.push(new ExpectFlowMappingKey());
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    private class ExpectFlowMappingSimpleValue
    implements EmitterState {
        private ExpectFlowMappingSimpleValue() {
        }

        @Override
        public void expect() {
            Emitter.this.writeIndicator(":", false, false, false);
            Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeInlineComments();
            Emitter.this.states.push(new ExpectFlowMappingKey());
            Emitter.this.expectNode(false, true, false);
            Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
            Emitter.this.writeInlineComments();
        }
    }

    private class ExpectFlowMappingKey
    implements EmitterState {
        private ExpectFlowMappingKey() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.MappingEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndicator(",", false, false, false);
                    Emitter.this.writeIndent();
                }
                if (Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.writeIndicator("}", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                Emitter.this.writeIndicator(",", false, false, false);
                Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
                Emitter.this.writeBlockComment();
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                if (!Emitter.this.canonical.booleanValue() && Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.push(new ExpectFlowMappingSimpleValue());
                    Emitter.this.expectNode(false, true, true);
                } else {
                    Emitter.this.writeIndicator("?", true, false, false);
                    Emitter.this.states.push(new ExpectFlowMappingValue());
                    Emitter.this.expectNode(false, true, false);
                }
            }
        }
    }

    private class ExpectFlowSequenceItem
    implements EmitterState {
        private ExpectFlowSequenceItem() {
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.SequenceEnd) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndicator(",", false, false, false);
                    Emitter.this.writeIndent();
                } else if (Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.writeIndicator("]", false, false, false);
                Emitter.this.inlineCommentsCollector.collectEvents();
                Emitter.this.writeInlineComments();
                if (Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.event = Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
            } else {
                Emitter.this.writeIndicator(",", false, false, false);
                Emitter.this.writeBlockComment();
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth && Emitter.this.splitLines || Emitter.this.multiLineFlow.booleanValue()) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.states.push(new ExpectFlowSequenceItem());
                Emitter.this.expectNode(false, false, false);
                Emitter.this.event = Emitter.this.inlineCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeInlineComments();
            }
        }
    }

    private class ExpectDocumentRoot
    implements EmitterState {
        private ExpectDocumentRoot() {
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            if (!Emitter.this.blockCommentsCollector.isEmpty()) {
                Emitter.this.writeBlockComment();
                if (Emitter.this.event instanceof DocumentEndEvent) {
                    new ExpectDocumentEnd().expect();
                    return;
                }
            }
            Emitter.this.states.push(new ExpectDocumentEnd());
            Emitter.this.expectNode(true, false, false);
        }
    }

    private class ExpectDocumentEnd
    implements EmitterState {
        private ExpectDocumentEnd() {
        }

        @Override
        public void expect() {
            Emitter.this.event = Emitter.this.blockCommentsCollector.collectEventsAndPoll(Emitter.this.event);
            Emitter.this.writeBlockComment();
            if (Emitter.this.event.getEventId() == Event.ID.DocumentEnd) {
                Emitter.this.writeIndent();
                if (((DocumentEndEvent)Emitter.this.event).isExplicit()) {
                    Emitter.this.writeIndicator("...", true, false, false);
                    Emitter.this.writeIndent();
                }
            } else {
                throw new EmitterException("expected DocumentEndEvent, but got " + Emitter.this.event);
            }
            Emitter.this.flushStream();
            Emitter.this.state = new ExpectDocumentStart(false);
        }
    }

    private class ExpectDocumentStart
    implements EmitterState {
        private final boolean first;

        public ExpectDocumentStart(boolean bl) {
            this.first = bl;
        }

        @Override
        public void expect() {
            if (Emitter.this.event.getEventId() == Event.ID.DocumentStart) {
                DocumentStartEvent documentStartEvent = (DocumentStartEvent)Emitter.this.event;
                this.handleDocumentStartEvent(documentStartEvent);
                Emitter.this.state = new ExpectDocumentRoot();
            } else if (Emitter.this.event.getEventId() == Event.ID.StreamEnd) {
                Emitter.this.writeStreamEnd();
                Emitter.this.state = new ExpectNothing();
            } else if (Emitter.this.event instanceof CommentEvent) {
                Emitter.this.blockCommentsCollector.collectEvents(Emitter.this.event);
                Emitter.this.writeBlockComment();
            } else {
                throw new EmitterException("expected DocumentStartEvent, but got " + Emitter.this.event);
            }
        }

        private void handleDocumentStartEvent(DocumentStartEvent documentStartEvent) {
            boolean bl;
            if ((documentStartEvent.getSpecVersion().isPresent() || !documentStartEvent.getTags().isEmpty()) && Emitter.this.openEnded) {
                Emitter.this.writeIndicator("...", true, false, false);
                Emitter.this.writeIndent();
            }
            documentStartEvent.getSpecVersion().ifPresent(specVersion -> Emitter.this.writeVersionDirective(Emitter.this.prepareVersion(specVersion)));
            Emitter.this.tagPrefixes = new LinkedHashMap(DEFAULT_TAG_PREFIXES);
            if (!documentStartEvent.getTags().isEmpty()) {
                this.handleTagDirectives(documentStartEvent.getTags());
            }
            boolean bl2 = bl = this.first && !documentStartEvent.isExplicit() && Emitter.this.canonical == false && !documentStartEvent.getSpecVersion().isPresent() && documentStartEvent.getTags().isEmpty() && !this.checkEmptyDocument();
            if (!bl) {
                Emitter.this.writeIndent();
                Emitter.this.writeIndicator("---", true, false, false);
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndent();
                }
            }
        }

        private void handleTagDirectives(Map<String, String> map) {
            TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
            for (String string : treeSet) {
                String string2 = map.get(string);
                Emitter.this.tagPrefixes.put(string2, string);
                String string3 = Emitter.this.prepareTagHandle(string);
                String string4 = Emitter.this.prepareTagPrefix(string2);
                Emitter.this.writeTagDirective(string3, string4);
            }
        }

        private boolean checkEmptyDocument() {
            if (Emitter.this.event.getEventId() != Event.ID.DocumentStart || Emitter.this.events.isEmpty()) {
                return false;
            }
            Event event = (Event)Emitter.this.events.peek();
            if (event.getEventId() == Event.ID.Scalar) {
                ScalarEvent scalarEvent = (ScalarEvent)event;
                return !scalarEvent.getAnchor().isPresent() && !scalarEvent.getTag().isPresent() && scalarEvent.getImplicit() != null && scalarEvent.getValue().isEmpty();
            }
            return false;
        }
    }

    private class ExpectFirstDocumentStart
    implements EmitterState {
        private ExpectFirstDocumentStart() {
        }

        @Override
        public void expect() {
            new ExpectDocumentStart(true).expect();
        }
    }

    private class ExpectNothing
    implements EmitterState {
        private ExpectNothing() {
        }

        @Override
        public void expect() {
            throw new EmitterException("expecting nothing, but got " + Emitter.this.event);
        }
    }
}

