/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.Anchor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.CharConstants;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.Event;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.ImplicitTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.NodeEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;

public final class ScalarEvent
extends NodeEvent {
    private final Optional<String> tag;
    private final ScalarStyle style;
    private final String value;
    private final ImplicitTuple implicit;

    public ScalarEvent(Optional<Anchor> optional, Optional<String> optional2, ImplicitTuple implicitTuple, String string, ScalarStyle scalarStyle, Optional<Mark> optional3, Optional<Mark> optional4) {
        super(optional, optional3, optional4);
        Objects.requireNonNull(optional2);
        this.tag = optional2;
        this.implicit = implicitTuple;
        Objects.requireNonNull(string);
        this.value = string;
        Objects.requireNonNull(scalarStyle);
        this.style = scalarStyle;
    }

    public ScalarEvent(Optional<Anchor> optional, Optional<String> optional2, ImplicitTuple implicitTuple, String string, ScalarStyle scalarStyle) {
        this(optional, optional2, implicitTuple, string, scalarStyle, Optional.empty(), Optional.empty());
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public ScalarStyle getScalarStyle() {
        return this.style;
    }

    public String getValue() {
        return this.value;
    }

    public ImplicitTuple getImplicit() {
        return this.implicit;
    }

    @Override
    public Event.ID getEventId() {
        return Event.ID.Scalar;
    }

    public boolean isPlain() {
        return this.style == ScalarStyle.PLAIN;
    }

    public boolean isLiteral() {
        return this.style == ScalarStyle.LITERAL;
    }

    public boolean isSQuoted() {
        return this.style == ScalarStyle.SINGLE_QUOTED;
    }

    public boolean isDQuoted() {
        return this.style == ScalarStyle.DOUBLE_QUOTED;
    }

    public boolean isFolded() {
        return this.style == ScalarStyle.FOLDED;
    }

    public boolean isJson() {
        return this.style == ScalarStyle.JSON_SCALAR_STYLE;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("=VAL");
        this.getAnchor().ifPresent(anchor -> stringBuilder.append(" &" + anchor));
        if (this.implicit.bothFalse()) {
            this.getTag().ifPresent(string -> stringBuilder.append(" <" + string + ">"));
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.getScalarStyle().toString());
        stringBuilder.append(this.escapedValue());
        return stringBuilder.toString();
    }

    public String escapedValue() {
        return this.value.codePoints().filter(n -> n < 65535).mapToObj(n -> CharConstants.escapeChar(String.valueOf(Character.toChars(n)))).collect(Collectors.joining(""));
    }
}

