/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions;

import java.util.Objects;
import java.util.Optional;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;

public class MarkedYamlEngineException
extends YamlEngineException {
    private final String context;
    private final Optional<Mark> contextMark;
    private final String problem;
    private final Optional<Mark> problemMark;

    protected MarkedYamlEngineException(String string, Optional<Mark> optional, String string2, Optional<Mark> optional2, Throwable throwable) {
        super(string + "; " + string2 + "; " + optional2, throwable);
        Objects.requireNonNull(optional, "contextMark must be provided");
        Objects.requireNonNull(optional2, "problemMark must be provided");
        this.context = string;
        this.contextMark = optional;
        this.problem = string2;
        this.problemMark = optional2;
    }

    protected MarkedYamlEngineException(String string, Optional<Mark> optional, String string2, Optional<Mark> optional2) {
        this(string, optional, string2, optional2, null);
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.context != null) {
            stringBuilder.append(this.context);
            stringBuilder.append("\n");
        }
        if (this.contextMark.isPresent() && (this.problem == null || !this.problemMark.isPresent() || this.contextMark.get().getName().equals(this.problemMark.get().getName()) || this.contextMark.get().getLine() != this.problemMark.get().getLine() || this.contextMark.get().getColumn() != this.problemMark.get().getColumn())) {
            stringBuilder.append(this.contextMark.get());
            stringBuilder.append("\n");
        }
        if (this.problem != null) {
            stringBuilder.append(this.problem);
            stringBuilder.append("\n");
        }
        if (this.problemMark.isPresent()) {
            stringBuilder.append(this.problemMark.get());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String getContext() {
        return this.context;
    }

    public Optional<Mark> getContextMark() {
        return this.contextMark;
    }

    public String getProblem() {
        return this.problem;
    }

    public Optional<Mark> getProblemMark() {
        return this.problemMark;
    }
}

