/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.CollectionNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;

public class MappingNode
extends CollectionNode<NodeTuple> {
    private List<NodeTuple> value;

    public MappingNode(Tag tag, boolean bl, List<NodeTuple> list, FlowStyle flowStyle, Optional<Mark> optional, Optional<Mark> optional2) {
        super(tag, flowStyle, optional, optional2);
        Objects.requireNonNull(list);
        this.value = list;
        this.resolved = bl;
    }

    public MappingNode(Tag tag, List<NodeTuple> list, FlowStyle flowStyle) {
        this(tag, true, list, flowStyle, Optional.empty(), Optional.empty());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAPPING;
    }

    @Override
    public List<NodeTuple> getValue() {
        return this.value;
    }

    public void setValue(List<NodeTuple> list) {
        Objects.requireNonNull(list);
        this.value = list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (NodeTuple nodeTuple : this.getValue()) {
            stringBuilder.append("{ key=");
            stringBuilder.append(nodeTuple.getKeyNode());
            stringBuilder.append("; value=");
            if (nodeTuple.getValueNode() instanceof CollectionNode) {
                stringBuilder.append(System.identityHashCode(nodeTuple.getValueNode()));
            } else {
                stringBuilder.append(nodeTuple);
            }
            stringBuilder.append(" }");
        }
        String string = stringBuilder.toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + string + ")>";
    }
}

