/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.AnchorNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;

public abstract class BaseRepresenter {
    protected final Map<Class<?>, RepresentToNode> representers = new HashMap();
    protected final Map<Class<?>, RepresentToNode> parentClassRepresenters = new LinkedHashMap();
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>(){

        @Override
        public Node put(Object object, Node node) {
            return super.put(object, new AnchorNode(node));
        }
    };
    protected RepresentToNode nullRepresenter;
    protected ScalarStyle defaultScalarStyle = ScalarStyle.PLAIN;
    protected FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    protected Object objectToRepresent;

    public Node represent(Object object) {
        Node node = this.representData(object);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return node;
    }

    protected Optional<RepresentToNode> findRepresenterFor(Object object) {
        Class<?> clazz = object.getClass();
        if (this.representers.containsKey(clazz)) {
            return Optional.of(this.representers.get(clazz));
        }
        for (Map.Entry<Class<?>, RepresentToNode> entry : this.parentClassRepresenters.entrySet()) {
            if (!entry.getKey().isInstance(object)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    protected final Node representData(Object object) {
        this.objectToRepresent = object;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            return this.representedObjects.get(this.objectToRepresent);
        }
        if (object == null) {
            return this.nullRepresenter.representData(null);
        }
        RepresentToNode representToNode = this.findRepresenterFor(object).orElseThrow(() -> new YamlEngineException("Representer is not defined for " + object.getClass()));
        return representToNode.representData(object);
    }

    protected Node representScalar(Tag tag, String string, ScalarStyle scalarStyle) {
        if (scalarStyle == ScalarStyle.PLAIN) {
            scalarStyle = this.defaultScalarStyle;
        }
        return new ScalarNode(tag, string, scalarStyle);
    }

    protected Node representScalar(Tag tag, String string) {
        return this.representScalar(tag, string, ScalarStyle.PLAIN);
    }

    protected Node representSequence(Tag tag, Iterable<?> iterable, FlowStyle flowStyle) {
        int n = 10;
        if (iterable instanceof List) {
            n = ((List)iterable).size();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        SequenceNode sequenceNode = new SequenceNode(tag, arrayList, flowStyle);
        this.representedObjects.put(this.objectToRepresent, sequenceNode);
        FlowStyle flowStyle2 = FlowStyle.FLOW;
        for (Object obj : iterable) {
            Node node = this.representData(obj);
            if (!(node instanceof ScalarNode) || !((ScalarNode)node).isPlain()) {
                flowStyle2 = FlowStyle.BLOCK;
            }
            arrayList.add(node);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                sequenceNode.setFlowStyle(this.defaultFlowStyle);
            } else {
                sequenceNode.setFlowStyle(flowStyle2);
            }
        }
        return sequenceNode;
    }

    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        return new NodeTuple(this.representData(entry.getKey()), this.representData(entry.getValue()));
    }

    protected Node representMapping(Tag tag, Map<?, ?> map, FlowStyle flowStyle) {
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>(map.size());
        MappingNode mappingNode = new MappingNode(tag, arrayList, flowStyle);
        this.representedObjects.put(this.objectToRepresent, mappingNode);
        FlowStyle flowStyle2 = FlowStyle.FLOW;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            NodeTuple nodeTuple = this.representMappingEntry(entry);
            if (!(nodeTuple.getKeyNode() instanceof ScalarNode) || !((ScalarNode)nodeTuple.getKeyNode()).isPlain()) {
                flowStyle2 = FlowStyle.BLOCK;
            }
            if (!(nodeTuple.getValueNode() instanceof ScalarNode) || !((ScalarNode)nodeTuple.getValueNode()).isPlain()) {
                flowStyle2 = FlowStyle.BLOCK;
            }
            arrayList.add(nodeTuple);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                mappingNode.setFlowStyle(this.defaultFlowStyle);
            } else {
                mappingNode.setFlowStyle(flowStyle2);
            }
        }
        return mappingNode;
    }
}

