/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.representer;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.representer.BaseRepresenter;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner.StreamReader;

public class StandardRepresenter
extends BaseRepresenter {
    public static final Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085");
    protected Map<Class<? extends Object>, Tag> classTags;
    protected DumpSettings settings;

    public StandardRepresenter(DumpSettings dumpSettings) {
        this.defaultFlowStyle = dumpSettings.getDefaultFlowStyle();
        this.defaultScalarStyle = dumpSettings.getDefaultScalarStyle();
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(UUID.class, new RepresentUuid());
        this.representers.put(Optional.class, new RepresentOptional());
        this.representers.put(byte[].class, new RepresentByteArray());
        RepresentPrimitiveArray representPrimitiveArray = new RepresentPrimitiveArray();
        this.representers.put(short[].class, representPrimitiveArray);
        this.representers.put(int[].class, representPrimitiveArray);
        this.representers.put(long[].class, representPrimitiveArray);
        this.representers.put(float[].class, representPrimitiveArray);
        this.representers.put(double[].class, representPrimitiveArray);
        this.representers.put(char[].class, representPrimitiveArray);
        this.representers.put(boolean[].class, representPrimitiveArray);
        this.parentClassRepresenters.put(Number.class, new RepresentNumber());
        this.parentClassRepresenters.put(List.class, new RepresentList());
        this.parentClassRepresenters.put(Map.class, new RepresentMap());
        this.parentClassRepresenters.put(Set.class, new RepresentSet());
        this.parentClassRepresenters.put(Iterator.class, new RepresentIterator());
        this.parentClassRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.parentClassRepresenters.put(Enum.class, new RepresentEnum());
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
        this.settings = dumpSettings;
    }

    protected Tag getTag(Class<?> clazz, Tag tag) {
        return this.classTags.getOrDefault(clazz, tag);
    }

    @Deprecated
    public Tag addClassTag(Class<? extends Object> clazz, Tag tag) {
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        return this.classTags.put(clazz, tag);
    }

    protected class RepresentNull
    implements RepresentToNode {
        protected RepresentNull() {
        }

        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }

    public class RepresentString
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            Tag tag = Tag.STR;
            ScalarStyle scalarStyle = ScalarStyle.PLAIN;
            String string = object.toString();
            if (StandardRepresenter.this.settings.getNonPrintableStyle() == NonPrintableStyle.BINARY && !StreamReader.isPrintable(string)) {
                tag = Tag.BINARY;
                byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
                String string2 = new String(byArray, StandardCharsets.UTF_8);
                if (!string2.equals(string)) {
                    throw new YamlEngineException("invalid string value has occurred");
                }
                string = Base64.getEncoder().encodeToString(byArray);
                scalarStyle = ScalarStyle.LITERAL;
            }
            if (StandardRepresenter.this.defaultScalarStyle == ScalarStyle.PLAIN && MULTILINE_PATTERN.matcher(string).find()) {
                scalarStyle = ScalarStyle.LITERAL;
            }
            return StandardRepresenter.this.representScalar(tag, string, scalarStyle);
        }
    }

    public class RepresentBoolean
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            String string = Boolean.TRUE.equals(object) ? "true" : "false";
            return StandardRepresenter.this.representScalar(Tag.BOOL, string);
        }
    }

    public class RepresentUuid
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(object.getClass(), new Tag(UUID.class)), object.toString());
        }
    }

    public class RepresentOptional
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            Optional optional = (Optional)object;
            if (optional.isPresent()) {
                Node node = StandardRepresenter.this.represent(optional.get());
                node.setTag(new Tag(Optional.class));
                return node;
            }
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }

    public class RepresentByteArray
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representScalar(Tag.BINARY, Base64.getEncoder().encodeToString((byte[])object), ScalarStyle.LITERAL);
        }
    }

    public class RepresentPrimitiveArray
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            Class<?> clazz = object.getClass().getComponentType();
            FlowStyle flowStyle = StandardRepresenter.this.settings.getDefaultFlowStyle();
            if (Byte.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asByteList(object), flowStyle);
            }
            if (Short.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asShortList(object), flowStyle);
            }
            if (Integer.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asIntList(object), flowStyle);
            }
            if (Long.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asLongList(object), flowStyle);
            }
            if (Float.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asFloatList(object), flowStyle);
            }
            if (Double.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asDoubleList(object), flowStyle);
            }
            if (Character.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asCharList(object), flowStyle);
            }
            if (Boolean.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asBooleanList(object), flowStyle);
            }
            throw new YamlEngineException("Unexpected primitive '" + clazz.getCanonicalName() + "'");
        }

        private List<Byte> asByteList(Object object) {
            byte[] byArray = (byte[])object;
            ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                arrayList.add(byArray[i]);
            }
            return arrayList;
        }

        private List<Short> asShortList(Object object) {
            short[] sArray = (short[])object;
            ArrayList<Short> arrayList = new ArrayList<Short>(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                arrayList.add(sArray[i]);
            }
            return arrayList;
        }

        private List<Integer> asIntList(Object object) {
            int[] nArray = (int[])object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(nArray[i]);
            }
            return arrayList;
        }

        private List<Long> asLongList(Object object) {
            long[] lArray = (long[])object;
            ArrayList<Long> arrayList = new ArrayList<Long>(lArray.length);
            for (int i = 0; i < lArray.length; ++i) {
                arrayList.add(lArray[i]);
            }
            return arrayList;
        }

        private List<Float> asFloatList(Object object) {
            float[] fArray = (float[])object;
            ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
            for (int i = 0; i < fArray.length; ++i) {
                arrayList.add(Float.valueOf(fArray[i]));
            }
            return arrayList;
        }

        private List<Double> asDoubleList(Object object) {
            double[] dArray = (double[])object;
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                arrayList.add(dArray[i]);
            }
            return arrayList;
        }

        private List<Character> asCharList(Object object) {
            char[] cArray = (char[])object;
            ArrayList<Character> arrayList = new ArrayList<Character>(cArray.length);
            for (int i = 0; i < cArray.length; ++i) {
                arrayList.add(Character.valueOf(cArray[i]));
            }
            return arrayList;
        }

        private List<Boolean> asBooleanList(Object object) {
            boolean[] blArray = (boolean[])object;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(blArray.length);
            for (int i = 0; i < blArray.length; ++i) {
                arrayList.add(blArray[i]);
            }
            return arrayList;
        }
    }

    public class RepresentNumber
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            String string;
            Tag tag;
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof BigInteger) {
                tag = Tag.INT;
                string = object.toString();
            } else {
                Number number = (Number)object;
                tag = Tag.FLOAT;
                string = number.equals(Double.NaN) || number.equals(Float.valueOf(Float.NaN)) ? ".nan" : (number.equals(Double.POSITIVE_INFINITY) || number.equals(Float.valueOf(Float.POSITIVE_INFINITY)) ? ".inf" : (number.equals(Double.NEGATIVE_INFINITY) || number.equals(Float.valueOf(Float.NEGATIVE_INFINITY)) ? "-.inf" : number.toString()));
            }
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(object.getClass(), tag), string);
        }
    }

    public class RepresentList
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(object.getClass(), Tag.SEQ), (List)object, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    public class RepresentMap
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(object.getClass(), Tag.MAP), (Map)object, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    public class RepresentSet
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Set set = (Set)object;
            for (Object e : set) {
                linkedHashMap.put(e, null);
            }
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(object.getClass(), Tag.SET), linkedHashMap, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    public class RepresentIterator
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            Iterator iterator = (Iterator)object;
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(object.getClass(), Tag.SEQ), new IteratorWrapper(iterator), StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    public class RepresentArray
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            Object[] objectArray = (Object[])object;
            List<Object> list = Arrays.asList(objectArray);
            return StandardRepresenter.this.representSequence(Tag.SEQ, list, StandardRepresenter.this.settings.getDefaultFlowStyle());
        }
    }

    public class RepresentEnum
    implements RepresentToNode {
        @Override
        public Node representData(Object object) {
            Tag tag = new Tag(object.getClass());
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(object.getClass(), tag), ((Enum)object).name());
        }
    }

    private static class IteratorWrapper
    implements Iterable<Object> {
        private final Iterator<Object> iter;

        public IteratorWrapper(Iterator<Object> iterator) {
            this.iter = iterator;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iter;
        }
    }
}

