/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.resolver.ResolverTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.resolver.ScalarResolver;

public abstract class BaseScalarResolver
implements ScalarResolver {
    public static final Pattern EMPTY = Pattern.compile("^$");
    public static final Pattern ENV_FORMAT = Pattern.compile("^\\$\\{\\s*(?:(\\w+)(?:(:?[-?])(\\w+)?)?)\\s*\\}$");
    protected Map<Character, List<ResolverTuple>> yamlImplicitResolvers = new HashMap<Character, List<ResolverTuple>>();

    public BaseScalarResolver() {
        this.addImplicitResolvers();
    }

    public void addImplicitResolver(Tag tag, Pattern pattern, String string) {
        if (string == null) {
            List list = this.yamlImplicitResolvers.computeIfAbsent(null, c -> new ArrayList());
            list.add(new ResolverTuple(tag, pattern));
        } else {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                List<ResolverTuple> list;
                Character c2 = Character.valueOf(cArray[i]);
                if (c2.charValue() == '\u0000') {
                    c2 = null;
                }
                if ((list = this.yamlImplicitResolvers.get(c2)) == null) {
                    list = new ArrayList<ResolverTuple>();
                    this.yamlImplicitResolvers.put(c2, list);
                }
                list.add(new ResolverTuple(tag, pattern));
            }
        }
    }

    abstract void addImplicitResolvers();

    @Override
    public Tag resolve(String string, Boolean bl) {
        Pattern pattern;
        Tag tag;
        if (!bl.booleanValue()) {
            return Tag.STR;
        }
        List<ResolverTuple> list = string.isEmpty() ? this.yamlImplicitResolvers.get(Character.valueOf('\u0000')) : this.yamlImplicitResolvers.get(Character.valueOf(string.charAt(0)));
        if (list != null) {
            for (ResolverTuple resolverTuple : list) {
                tag = resolverTuple.getTag();
                pattern = resolverTuple.getRegexp();
                if (!pattern.matcher(string).matches()) continue;
                return tag;
            }
        }
        if (this.yamlImplicitResolvers.containsKey(null)) {
            for (ResolverTuple resolverTuple : this.yamlImplicitResolvers.get(null)) {
                tag = resolverTuple.getTag();
                pattern = resolverTuple.getRegexp();
                if (!pattern.matcher(string).matches()) continue;
                return tag;
            }
        }
        return Tag.STR;
    }
}

